package com.clx.performance.vo.pc.breakcontract.carrier;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import jakarta.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.Map;

/**
 * @author liruixin
 * Date 2023-10-24
 * Time 16:02
 */
@Getter
@Setter
@ToString
@NoArgsConstructor
public class BreakContractDriverRuleVO {

    @Schema(description = "司机取消规则")
    private DriverCancelRule driverCancelRule;

    @Schema(description = "货源地超时规则")
    private SendAddressRule sendAddressRule;

    @Schema(description = "目的地超时规则")
    private ReceiveAddressRule receiveAddressRule;

    @Getter
    @Setter
    @ToString
    @NoArgsConstructor
    public static class DriverCancelRule{

        @Schema(description="接单时间小于X小时")
        @NotNull(message = "参数不能为空")
        private BigDecimal baseTime;

        @Schema(description="收费X元")
        @NotNull(message = "参数不能为空")
        private BigDecimal baseFigure;

        @Schema(description="每小时加收X元")
        @NotNull(message = "参数不能为空")
        private BigDecimal figurePerHour;
    }

    @Getter
    @Setter
    @ToString
    @NoArgsConstructor
    public static class SendAddressRule{
        @Schema(description="每小时收X元")
        @NotNull(message = "参数不能为空")
        private BigDecimal figurePerHour;
    }

    @Getter
    @Setter
    @ToString
    @NoArgsConstructor
    public static class ReceiveAddressRule{
        @Schema(description="每小时每吨收X元")
        @NotNull(message = "参数不能为空")
        private BigDecimal figurePerHour;
    }

}
