package com.clx.performance.vo.pc;

import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
* @Author: aiqinguo
* @Description: 积分货单
* @Date: 2023-10-10 09:47:04
* @Version: 1.0
*/

@Schema(description = "积分货单")
@Getter
@Setter
@ToString
@NoArgsConstructor
public class IntegralOrderVO {

    @Schema(description = "id", example = "1")
    private Integer id;
    @Schema(description = "货单编号", example = "1000000000000")
    private String orderGoodsNo;
    @Schema(description = "发货地址id", example = "1")
    private Integer sendAddressId;
    @Schema(description = "发货地址", example = "北京")
    private String sendAddress;
    @Schema(description = "收货地址id", example = "2")
    private Integer receiveAddressId;
    @Schema(description = "收货地址", example = "上海")
    private String receiveAddress;
    @Schema(description = "货单类型：1优质单 2普通单 3流水单 4支援单", example = "1")
    private Integer orderType;
    @Schema(description = "车辆梯队", example = "1")
    private Integer truckEchelon;
    @Schema(description = "创建时间", example = "")
    private String createTime;
    @Schema(description = "修改时间", example = "")
    private String modifiedTime;

}