package com.clx.performance.param.temp;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import java.math.BigDecimal;
import java.util.List;

@Setter
@Getter
@ToString
@NoArgsConstructor
public class TruckTraceAddParam {

    @Schema(description = "车辆轨迹列表")
    private List<TruckTraceItem> traceList;

    @Setter
    @Getter
    @ToString
    @NoArgsConstructor
    public static class TruckTraceItem{
        @Schema(description = "车辆编号", example = "京A12345")
        private String truckNo;
        @Schema(description = "正北方向夹角", example = "12.34")
        private BigDecimal angle;
        @Schema(description = "速度", example = "12.34")
        private BigDecimal speed;
        @Schema(description = "里程", example = "12.34")
        private BigDecimal mileage;
        @Schema(description = "海拔", example = "12.34")
        private BigDecimal height;
        @Schema(description = "位置 [123.45, 12.34]")
        private BigDecimal[] location;
        @Schema(description = "时间")
        private String gpsTime;
    }

}
