package com.clx.performance.param.feign.transport;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.time.LocalDateTime;

@Getter
@Setter
@ToString
@NoArgsConstructor
public class OrderChildTruckInfoDTO {

//    @Schema(description = "运单号", required = true)
//    private String childNo;
//    @Schema(description = "车辆ID", required = true)
//    private Integer truckId;
//    @Schema(description = "车主id", required = true)
//    private Integer userId;

    @Schema(description = "车主手机号", required = true)
    @NotBlank(message = "车主手机号不能为空")
    private String mobile;
    @Schema(description = "车牌号", required = true)
    @NotBlank(message = "车牌号不能为空")
    private String truckNo;

//    @Schema(description = "车头车牌颜色代码", required = true)
//    private Integer truckNoColorCode;

    @Schema(description = "车头车牌颜色", required = true)
    @NotBlank(message = "车头车牌颜色不能为空")
    private String truckNoColor;
    @Schema(description = "型号", required = true)
    @NotBlank(message = "型号不能为空")
    private String model;
    @Schema(description = "载重单位吨", required = true)
    @NotNull(message = "载重单位吨不能为空")
    private Integer load;
    @Schema(description = "吨位 单位吨", required = true)
    @NotNull(message = "吨位不能为空")
    private Integer grossMass;

    @Schema(description = "车头道路运输许可证编号", required = true)
    @NotBlank(message = "车头道路运输许可证编号不能为空")
    private String roadTransportCertificateNo;
    @Schema(description = "行驶证主页照片", required = true)
    @NotBlank(message = "行驶证主页照片不能为空")
    private String licenceImgMain;
    @Schema(description = "行驶证副业正面照片", required = true)
    @NotBlank(message = "行驶证副业正面照片不能为空")
    private String licenceImgSecond;
    @Schema(description = "行驶证副业背面照片", required = true)
    @NotBlank(message = "行驶证副业背面照片不能为空")
    private String licenceImgSecondBack;
    @Schema(description = "道路运输许可证图片地址", required = true)
    @NotBlank(message = "道路运输许可证图片地址不能为空")
    private String transportLicenceImg;

    @Schema(description = "行驶证有效期开始时间")
    private String drivingLicenseBeginTime;
    @Schema(description = "行驶证有效期结束时间", required = true)
    @NotBlank(message = "行驶证有效期结束时间不能为空")
    private String drivingLicenseEndTime;
    @Schema(description = "运输证有效期开始时间")
    private String transportationLicenseBeginTime;
    @Schema(description = "运输证有效期结束时间")
    private String transportationLicenseEndTime;

    @Schema(description = "挂车牌号")
    private String truckNo2;
    @Schema(description="挂车行驶证主页")
    private String licenceImgMain2;
    @Schema(description="挂车行驶证副页")
    private String licenceImgSecond2;
    @Schema(description="挂车行驶证副页背面")
    private String licenceImgSecond2Back;
    @Schema(description="挂车年检有效期至")
    private String licenceImgMain2EndTime;
    @Schema(description="挂车道路运输许可证编号")
    private String roadTransportCertificateNo2;
    @Schema(description="挂车道路运输许可证图片地址")
    private String transportLicenceImg2;

    @Schema(description = "车辆燃料类型 1：柴油 2 天然气 3其他 4新能源/电", required = true)
    @NotNull(message = "车辆燃料类型不能为空")
    private Integer powerType;
    @Schema(description = "使用性质", required = true)
    @NotBlank(message = "使用性质不能为空")
    private String useNature;
    @Schema(description = "车辆识别代码", required = true)
    @NotBlank(message = "车辆识别代码不能为空")
    private String identifyCode;
    @Schema(description = "行驶证发证机关", required = true)
    @NotBlank(message = "行驶证发证机关不能为空")
    private String licenceIssueOrganization;
    @Schema(description = "注册日期", required = true)
    @NotBlank(message = "注册日期不能为空")
    private String registerDate;
    @Schema(description = "行驶证发证日期", required = true)
    @NotBlank(message = "行驶证发证日期不能为空")
    private String licenceIssueDate;

}
