package com.clx.performance.param.app.breakcontract;

import com.msl.common.base.PageParam;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import jakarta.validation.constraints.NotNull;

@Getter
@Setter
@NoArgsConstructor
@ToString
public class DriverPageBreakContractDriverRecordParam extends PageParam {

    @Schema(description = "类型：1违约记录 2平台补偿 ", example = "1")
    @NotNull(message = "类型不能为空")
    private Integer type;

    @Schema(description = "创建时间")
    private String createTime;

    @Schema(description = "开始时间", hidden = true)
    private String beginTime;

    @Schema(description = "结束时间", hidden = true)
    private String endTime;

    @Schema(description = "用户编号", hidden = true)
    private Long userNo;
}