package com.clx.performance.dao.loan;


import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.mapper.loan.BorrowerMapper;
import com.clx.performance.model.loan.Borrower;
import com.clx.performance.param.pc.loan.carrier.PageBorrowerParam;
import com.clx.performance.vo.pc.loan.carrier.BorrowerVO;
import com.clx.performance.vo.pc.loan.owner.BorrowerSelectVO;
import com.msl.common.base.Optional;
import com.msl.common.dao.BaseDao;

import java.util.List;

/**
 * @Author: aiqinguo
 * @Description: 借出方
 * @Date: 2024/01/17 13:42:57
 * @Version: 1.0
 */
public interface BorrowerDao extends BaseDao<BorrowerMapper, Borrower, Integer> {

    boolean update(Borrower item);
    boolean updateStatus(Borrower item);
    boolean updateDelete(Borrower item);

    Optional<Borrower> selectByName(String name);
    List<Borrower> listEnable();

    IPage<BorrowerVO> pageByParam(PageBorrowerParam param);

    List<BorrowerSelectVO> selectAllBorrowConfig();
}
