package com.clx.performance.controller.pc.loan.owner;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.param.pc.loan.carrier.OwnerLoanAccountApproveParam;
import com.clx.performance.param.pc.loan.carrier.PageOwnerLoanAccountApproveParam;
import com.clx.performance.service.loan.OwnerLoanAccountApproveService;
import com.clx.performance.vo.pc.loan.carrier.OwnerLoanAccountApproveVO;
import com.msl.common.base.PageData;
import com.msl.common.result.Result;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.Operation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @ClassName CarrierOwnerLoanAccountApproveController
 * @Description
 * @Author kavin
 * @Date 2024/1/20 17:52
 * @Version 1.0
 */
@Slf4j
@RestController
@RequestMapping(value="/pc/owner/loanAccountApprove")
@Validated
@Tag(name = "货主端-资金管理（货主借款账户管理（申请开通借款账户））")
@AllArgsConstructor
public class OwnerLoanAccountApproveController {

    private final OwnerLoanAccountApproveService ownerLoanAccountApproveService;

    @Operation(summary = "账户申请记录",description = "<br>By:刘海泉")
    @GetMapping("/getOwnerLoanAccountApproveList")
    public Result<List<OwnerLoanAccountApproveVO>> getOwnerLoanAccountApproveList() {
        List<OwnerLoanAccountApproveVO> list  = ownerLoanAccountApproveService.getOwnerLoanAccountApproveList();
        return Result.ok(list);
    }
}
