package com.clx.performance.controller.pc.carrier;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.param.pc.carrier.PagePerformanceProgress;
import com.clx.performance.param.pc.carrier.UpdatePerformanceProgressParam;
import com.clx.performance.service.PerformanceProgressService;
import com.clx.performance.vo.pc.PerformanceProgressDetailVO;
import com.clx.performance.vo.pc.PerformanceProgressOperationLogVO;
import com.clx.performance.vo.pc.PerformanceProgressVO;
import com.msl.common.base.PageData;
import com.msl.common.convertor.aspect.UnitCovert;
import com.msl.common.result.Result;
import com.msl.user.data.UserSessionData;
import com.msl.user.utils.TokenUtil;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.annotations.Operation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.util.List;

@Slf4j
@RestController
@RequestMapping(value="/pc/carrier/performanceProgress")
@Validated
@Tag(name = "承运端-履约进度表")
@AllArgsConstructor
public class CarrierPerformanceProgressController {


    private final PerformanceProgressService performanceProgressService;


    @Operation(summary = "履约进度表列表",description = "<br>By:刘海泉")
    @PostMapping("/pagePerformanceProgress")
    @UnitCovert(param = false)
    public Result<PageData<PerformanceProgressVO>> pagePerformanceProgress(@RequestBody @Validated PagePerformanceProgress param) {
        IPage<PerformanceProgressVO> page  = performanceProgressService.pagePerformanceProgress(param);
        return Result.page(page.getRecords(),page.getTotal(),page.getPages());
    }


    @Operation(summary = "进行中数据调整顺序",description = "<br>By:刘海泉")
    @GetMapping("/updateAdjustOrder")
    public Result<Object> updateAdjustOrder(
              @RequestParam("adjustOrderOneId") @NotNull(message = "调整订单1的id不能为空") Integer adjustOrderId,
            @RequestParam("adjustOrderTwoId") @NotNull(message = "调整订单2的id不能为空") Integer adjustOrderBeforeId
            ) {
        performanceProgressService.updateAdjustOrder(adjustOrderId,adjustOrderBeforeId);
        return Result.ok();
    }


    @Operation(summary = "编辑履约进度",description = "<br>By:刘海泉")
    @PostMapping("/updatePerformanceProgress")
    public Result<Object> updatePerformanceProgress(@RequestBody @Validated UpdatePerformanceProgressParam param) {
        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();
        performanceProgressService.updatePerformanceProgress(param,loginUserInfo.getUserNo(),loginUserInfo.getUserName());
        return Result.ok();
    }


    @Operation(summary = "获取履约进度详情",description = "<br>By:刘海泉")
    @GetMapping("/getPerformanceProgressDetail")
    public Result<PerformanceProgressDetailVO> getPerformanceProgressDetail(@RequestParam("id") @NotNull(message = "id不能为空") Integer id) {
        PerformanceProgressDetailVO vo = performanceProgressService.getPerformanceProgressDetail(id);
        return Result.ok(vo);
    }


    @Operation(summary = "获取履约进度编辑日志列表",description = "<br>By:刘海泉")
    @GetMapping("/getOperationLog")
    public Result<List<PerformanceProgressOperationLogVO>> getOperationLog(@RequestParam("orderNo") @NotBlank(message = "订单编号不能为空") String orderNo) {
        List<PerformanceProgressOperationLogVO> list  = performanceProgressService.getOperationLog(orderNo,null);
        return Result.ok(list);
    }

    @Operation(summary = "导出履约进度",description = "<br>By:杨启发")
    @PostMapping("/exportPerformanceProgress")
    public void exportPerformanceProgress(@RequestBody PagePerformanceProgress param, HttpServletResponse response) throws Exception {
        try (SXSSFWorkbook workbook = performanceProgressService.exportPerformanceProgress(param)) {
            response.setHeader(HttpHeaders.CONTENT_TYPE, MediaType.APPLICATION_OCTET_STREAM_VALUE);
            workbook.write(response.getOutputStream());
        }
    }
}
