package com.clx.performance.controller.feign;

import cn.hutool.core.collection.CollectionUtil;
import com.clx.performance.model.settle.SettlementOwnerDetail;
import com.clx.performance.service.settle.SettlementOwnerDetailService;
import com.msl.common.result.Result;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.AllArgsConstructor;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import jakarta.validation.constraints.NotNull;
import java.util.List;

@RestController
@RequestMapping("/feign/settlement")
@Validated
@Tag(name = "货单Feign")
@AllArgsConstructor
public class SettlementFeignController {

    private final SettlementOwnerDetailService settlementOwnerDetailService;


    @GetMapping({"/thawAndLockSettlement"})
    Result<Boolean> selectListByOrderNo(@RequestParam("orderNo") @NotNull(message = "订单号不能为空") String orderNo) {
        return Result.ok(settlementOwnerDetailService.thawAndLockSettlement(orderNo));

    }

}
