/*
 * Decompiled with CFR 0.152.
 */
package cn.com.infosec.netsign.agent.test;

import cn.com.infosec.netsign.agent.PBCAgent2G;
import cn.com.infosec.netsign.logger.ConsoleLogger;

public class TestCUPSTC {
    public static final String signCertDN = "C=cn,O=INFOSEC Technologies RSA,CN=10year";

    public static void main(String[] args) {
        TestCUPSTC.testSetWorkingKey();
        TestCUPSTC.testEncrypt();
    }

    public static void testEncrypt() {
        PBCAgent2G agent = TestCUPSTC.connectServer();
        String enc = "szf4rQgw620lF8eCF0YIaH7D5YrHyn0a/VjRNutrXjdfoESd4vc2mVfavFYoAUTGQD0K7c1K0OZEy8OiDNr3rjcZOXFaxKOQvlL2GC+krQUvv5ji0YRuNBnhgEYEjBQeBqgtq581XTOLIK82zp/QqXu1ab72t8oU5lzO7aXJhqmRsTWkVTKUg4IDY2IYLbO3/2U1wJm+ypk8D3LwX6CHwtO57iZgBOn9zlUYcmMio7BmgESzU0XC30uvz6nuitWy";
        byte[] plain = agent.CUPSTCDecrypt(enc, "3");
        System.out.println(agent.getReturnCode());
        ConsoleLogger.isDebug = true;
        ConsoleLogger.logBinary("plain", plain);
        System.out.println(new String(plain));
    }

    public static void testSetWorkingKey() {
        PBCAgent2G agent = TestCUPSTC.connectServer();
        boolean ret = agent.CUPSTCSetWorkingKey("A2151B8D21DDE67A2D56EA92195B5141", "3");
        System.out.println(ret);
    }

    public static void testSign() {
        PBCAgent2G agent = TestCUPSTC.connectServer();
        String signed = agent.CUPSTCRawSign("11111111".getBytes(), signCertDN, "SHA256");
        System.out.println(signed);
        boolean verified = agent.CUPSTCRawVerify("11111111".getBytes(), signed, signCertDN, "SHA256");
        System.out.println(verified);
        agent.closeSignServer();
    }

    public static void testEncryptWorkingKey() {
        PBCAgent2G agent = TestCUPSTC.connectServer();
        String enc = agent.CUPSTCEncryptWorkingKey("12345678123456781234567812345678", signCertDN);
        System.out.println(enc);
        String dec = agent.CUPSTCDecryptWorkingKey(enc, signCertDN);
        System.out.println(dec);
        agent.closeSignServer();
    }

    private static PBCAgent2G connectServer() {
        PBCAgent2G agent = new PBCAgent2G();
        agent.openSignServer("10.20.89.240", 10001, "12345678");
        return agent;
    }
}

