package com.clx.performance.controller.pc;

import com.clx.performance.dto.zjxl.TruckTraceDTO;
import com.clx.performance.param.pc.PageTruckListParam;
import com.clx.performance.param.pc.PageVicinityTruckListParam;
import com.clx.performance.service.TruckService;
import com.clx.performance.vo.pc.PageTruckListVO;
import com.msl.common.base.PageData;
import com.msl.common.result.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * @ClassName GoodsOrderController
 * @Description
 * @Author kavin
 * @Date 2023/9/17 17:16
 * @Version 1.0
 */

@Slf4j
@RestController
@RequestMapping("/pc/truck")
@Validated
@Api(tags = "PC-车辆列表")
public class TruckController {

    @Autowired
    TruckService truckService;

    
    @ApiOperation(value = "获取车辆列表", notes = "<br>By:刘海泉")
    @PostMapping("/pageTruckList")
    public Result<PageData<PageTruckListVO>> pageTruckList(@RequestBody @Validated PageTruckListParam param) {
        PageData<PageTruckListVO> page = truckService.pageTruckList(param);
        return Result.ok(page);
    }

    @ApiOperation(value = "手动更新平台车辆定位信息", notes = "<br>By:刘海泉")
    @GetMapping("/handExecTruckTrace")
    public Result handExecTruckTrace() {
        truckService.handExecTruckTrace();
        return Result.ok();
    }



    @ApiOperation(value = "获取附近的车辆", notes = "<br>By:刘海泉")
    @PostMapping("/getVicinityTruckList")
    public Result<PageData<PageTruckListVO>> getVicinityTruckList(@RequestBody @Validated PageVicinityTruckListParam param) {
        PageData<PageTruckListVO> page = truckService.getVicinityTruckList(param);
        return Result.ok(page);
    }

    @ApiOperation(value = "手动添加中交兴路的车辆定位信息", notes = "<br>By:刘海泉")
    @PostMapping("/addTruckGPSInfo")
    public Result addTruckGPSInfo(@RequestBody @Validated TruckTraceDTO truckTraceDTO) {
        truckService.addTruckGPSInfo(truckTraceDTO);
        return Result.ok();
    }






}
