package com.clx.performance.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.order.feign.OrderFeign;
import com.clx.order.params.PageOrderGoodsListParam;
import com.clx.order.vo.feign.FeignOrderVO;
import com.clx.performance.dao.OrderGoodsDao;
import com.clx.performance.dao.OrderGoodsDriverTruckDao;
import com.clx.performance.dao.OrderGoodsTruckBindDao;
import com.clx.performance.model.OrderGoods;
import com.clx.performance.model.OrderGoodsDriverTruck;
import com.clx.performance.model.OrderGoodsTruckBind;
import com.clx.performance.param.app.OrderGoodsListPageParam;
import com.clx.performance.service.OrderGoodsService;
import com.clx.performance.struct.OrderGoodsStruct;
import com.clx.performance.vo.app.OrderGoodsAPPVO;
import com.clx.performance.vo.feign.OrderGoodsFeignVO;
import com.clx.performance.vo.pc.OrderGoodsVO;
import com.clx.user.feign.UserClxFeign;
import com.msl.common.base.Optional;
import com.msl.common.enums.ResultCodeEnum;
import com.msl.common.result.Result;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * @author kavin
 * Date 2023-09-17
 * Time 16:45
 */
@Service
@Slf4j
public class OrderGoodsServiceImpl implements OrderGoodsService {

    @Autowired
    private OrderGoodsDao orderGoodsDao;

    @Autowired
    private OrderGoodsStruct orderGoodsStruct;

    @Autowired
    private OrderFeign orderFeign;

    @Autowired
    private OrderGoodsTruckBindDao orderGoodsTruckBindDao;

    @Autowired
    private OrderGoodsDriverTruckDao orderGoodsDriverTruckDao;

    @Autowired
    private UserClxFeign userClxFeign;

    @Override
    public OrderGoodsVO getOrderGoodsInfoByOrderGoodsNoForPC(String orderGoodsNo) {
        OrderGoodsVO orderGoodsVO = orderGoodsDao.getOrderGoodsInfoByOrderGoodsNoForPC(orderGoodsNo).map(orderGoodsStruct::convert).get();
        String orderNo = orderGoodsVO.getOrderNo();
        FeignOrderVO orderInfoFeign = orderFeign.getOrderInfoFeign(orderNo);
        orderGoodsVO.setReveiveAddressAll(orderInfoFeign.getReveiveAddressAll());
        orderGoodsVO.setSendAddressAll(orderInfoFeign.getSendAddressAll());
        return orderGoodsVO;
    }

    @Override
    public OrderGoodsVO getOrderGoodsInfoByOrderGoodsNoForAPP(String orderGoodsNo) {
        OrderGoodsVO orderGoodsVO = orderGoodsDao.getOrderGoodsInfoByOrderGoodsNoForAPP(orderGoodsNo).map(orderGoodsStruct::convert).get();
        String orderNo = orderGoodsVO.getOrderNo();
        FeignOrderVO orderInfoFeign = orderFeign.getOrderInfoFeign(orderNo);
        orderGoodsVO.setReveiveAddressAll(orderInfoFeign.getReveiveAddressAll());
        orderGoodsVO.setSendAddressAll(orderInfoFeign.getSendAddressAll());
        orderGoodsVO.setResidueTransportWeight(BigDecimal.ZERO.compareTo(orderGoodsVO.getResidueTransportWeight()) > 0?BigDecimal.ZERO:orderGoodsVO.getResidueTransportWeight());
        return orderGoodsVO;
    }

    @Override
    public IPage<OrderGoodsVO> pageOrderGoodsList(PageOrderGoodsListParam param) {
        return orderGoodsDao.pageOrderGoodsList(param);
    }

    @Override
    public void updateOrderGoodsReduceWeightAndStatus(Integer id, BigDecimal orderChildWeight, Integer orderGoodsStatus) {
        orderGoodsDao.updateOrderGoodsReduceWeightAndStatus(id, orderChildWeight, orderGoodsStatus);
    }

    @Override
    public IPage<OrderGoodsAPPVO> indexOrderGoodsList(OrderGoodsListPageParam orderGoodsListParam) {
        if (StringUtils.equals(orderGoodsListParam.getOrderGoodsType(), "1")) {
            return orderGoodsDao.openOrderPageGoodsList(orderGoodsListParam);
        } else {
            Optional<List<OrderGoodsDriverTruck>> truckList = orderGoodsDriverTruckDao.
                    selectListByDriverUserNo(orderGoodsListParam.getDriverUserNo());

            List<String> truckNoList = new ArrayList<>();

            //查询当前用户是否是货主
            Long driverUserNo = orderGoodsListParam.getDriverUserNo();
            Result<List<String>> ownTruckByUserNo = userClxFeign.getOwnTruckByUserNo(driverUserNo);
            log.info("通过用户编号:{} 查询本人车辆，查询结果:{}",driverUserNo,ownTruckByUserNo);
            if (Objects.equals(ownTruckByUserNo.getCode(),ResultCodeEnum.SUCCESS.getCode())) {
                if ((!truckList.isPresent() || CollectionUtils.isEmpty(truckList.get())) &&  ownTruckByUserNo.getData().isEmpty()) {
                    log.warn("用户编号:{},当前用户未绑定车辆",driverUserNo);
                    return new Page<>();
                }
                truckNoList.addAll(ownTruckByUserNo.getData());//当前用户自己的车
                truckNoList.addAll(truckList.get().stream().map(OrderGoodsDriverTruck::getTruckNo).collect(Collectors.toList()));//当前用户被绑定为司机的车
            }
            if(CollectionUtils.isEmpty(truckNoList)){
                log.warn("用户编号:{},查询车主车辆和作为司机的车辆全未查询到数据",driverUserNo);
                return new Page<>();
            }
            Optional<List<OrderGoodsTruckBind>> orderGoodsDriverTrucks = orderGoodsTruckBindDao.selectListByTruckNo(
                    truckNoList);
            if (!orderGoodsDriverTrucks.isPresent() ||   orderGoodsDriverTrucks.get().isEmpty()) {
                log.warn("用户编号:{},无专属单",driverUserNo);
                return new Page<>();
            }

            List<String> orderGoodsNoList = orderGoodsDriverTrucks.get().stream().map(OrderGoodsTruckBind::getOrderGoodsNo).collect(Collectors.toList());
            return orderGoodsDao.exclusiveOrderPageGoodsList(orderGoodsListParam, orderGoodsNoList);
        }
    }

    @Override
    public List<OrderGoodsFeignVO> getOrderGoodsListByOrderNo(String orderNo) {
        List<OrderGoods> list = orderGoodsDao.getOrderGoodsListByOrderNo(orderNo);
        return orderGoodsStruct.convertList(list);
    }

    @Override
    public List<OrderGoods> getOrderGoodsList(String orderNo, LocalDateTime lastArriveSendTime) {
        return orderGoodsDao.getOrderGoodsListByOrderNoAndLastArriveSendTime(orderNo, lastArriveSendTime);
    }


}
