package com.clx.performance.extranal.user.impl;

import com.clx.performance.extranal.user.DriverService;
import com.clx.user.feign.DriverFeign;
import com.clx.user.vo.feign.DriverTruckInfoFeignVo;
import com.msl.common.base.Optional;
import com.msl.common.enums.ResultCodeEnum;
import com.msl.common.exception.ServiceSystemException;
import com.msl.common.result.Result;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.Objects;

@Slf4j
@Service
@AllArgsConstructor
public class DriverServiceImpl implements DriverService {

    private final DriverFeign driverFeign;

    @Override
    public Optional<DriverTruckInfoFeignVo> getUserDetailInfo(Long driverUserNo, Integer truckId) {
        Result<DriverTruckInfoFeignVo> result = Optional.ofNullable(driverFeign.getDriverTruckInfo(driverUserNo, truckId)).orElseThrow(ResultCodeEnum.FAIL);

        if (!Objects.equals(result.getCode(), 0)){
            throw new ServiceSystemException(ResultCodeEnum.FAIL, result.getMsg());
        }

        return Optional.ofNullable(result.getData());
    }

    @Override
    public void updateOrderStatus(Long driverUserNo, Integer driverOrderStatus, Integer truckId, Integer truckOrderStatus){
        Optional.ofNullable(driverFeign.updateOrderStatus(driverUserNo, driverOrderStatus, truckId, truckOrderStatus))
                .filter(Result::succeed).orElseThrow(ResultCodeEnum.FAIL);
    }

}
