package com.clx.performance.dao.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.clx.performance.dao.OrderGoodsTruckBindDao;
import com.clx.performance.enums.OrderGoodsTruckBindEnum;
import com.clx.performance.mapper.OrderGoodsTruckBindMapper;
import com.clx.performance.model.OrderGoodsTruckBind;
import com.msl.common.base.Optional;
import com.msl.common.dao.impl.BaseDaoImpl;
import com.msl.common.utils.DateUtils;
import org.springframework.stereotype.Repository;

import java.time.LocalDateTime;
import java.util.List;

/**
 * @Author: huyufan
 * @Description: 货单定向绑定车辆表
 * @Date: 2023/09/18 11:34:50
 * @Version: 1.0
 */
@Repository
public class OrderGoodsTruckBindDaoImpl extends BaseDaoImpl<OrderGoodsTruckBindMapper, OrderGoodsTruckBind, Integer> implements OrderGoodsTruckBindDao {


    @Override
    public void saveBatchEntity(String orderNo, String orderGoodsNo, List<String> trackList, LocalDateTime now) {
        baseMapper.saveBatchEntity(orderNo, orderGoodsNo, trackList, DateUtils.formatDateTime(now).get());
    }

    @Override
    public boolean updateStatus(OrderGoodsTruckBind item) {
        return update(lUdWrapper()
                .eq(OrderGoodsTruckBind::getId, item.getId())
                .set(OrderGoodsTruckBind::getStatus, item.getStatus())
        );
    }

    @Override
    public List<Integer> getTrucksByOrderGoodsNo(String orderGoodsNo) {
        return baseMapper.getTrucksByOrderGoodsNo(orderGoodsNo);
    }

    @Override
    public Optional<OrderGoodsTruckBind> getByOrderGoodsNoAndTruckNo(String orderGoodsNo, String truckNo) {
        return Optional.ofNullable(getOne(lQrWrapper()
                        .eq(OrderGoodsTruckBind::getOrderGoodsNo, orderGoodsNo)
                        .eq(OrderGoodsTruckBind::getTruckNo, truckNo)
                ));

    }

    @Override
    public Optional<OrderGoodsTruckBind> getValidByOrderGoodsNoAndTruckNo(String truckNo) {
        return Optional.ofNullable(getOne(lQrWrapper()
                .eq(OrderGoodsTruckBind::getTruckNo, truckNo)
                .in(OrderGoodsTruckBind::getStatus, OrderGoodsTruckBind.Status.NORMAL.getCode())
        ));
    }

    @Override
    public Optional<List<OrderGoodsTruckBind>> getValidByTruckNo(String truckNo) {
        return Optional.ofNullable(list(lQrWrapper()
                .eq(OrderGoodsTruckBind::getTruckNo, truckNo)
                .in(OrderGoodsTruckBind::getStatus, OrderGoodsTruckBind.Status.NORMAL.getCode())
        ));
    }


    @Override
    public Optional<List<OrderGoodsTruckBind>> selectListByTruckNo(List<String> truckList) {
        return Optional.ofNullable(baseMapper.selectList(new QueryWrapper<OrderGoodsTruckBind>().lambda()
                        .eq(OrderGoodsTruckBind::getStatus, OrderGoodsTruckBindEnum.Status.SUCCESS.getCode())
                .in(OrderGoodsTruckBind::getTruckNo,truckList).select(OrderGoodsTruckBind::getOrderGoodsNo)));
    }
}
