package com.clx.performance.dao.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.order.enums.OrderEnum;
import com.clx.order.params.PageOrderGoodsListParam;
import com.clx.performance.dao.OrderGoodsDao;
import com.clx.performance.enums.OrderGoodsStatusEnum;
import com.clx.performance.mapper.OrderGoodsMapper;
import com.clx.performance.model.OrderGoods;
import com.clx.performance.param.app.OrderGoodsListPageParam;
import com.clx.performance.vo.app.OrderGoodsAPPVO;
import com.clx.performance.vo.feign.OrderGoodsFeignVO;
import com.clx.performance.vo.pc.OrderGoodsVO;
import com.msl.common.base.Optional;
import com.msl.common.dao.impl.BaseDaoImpl;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;

/**
 * @author kavin
 * Date 2023-09-17
 * Time 16:45
 */
@Repository
public class OrderGoodsDaoImpl extends BaseDaoImpl<OrderGoodsMapper, OrderGoods, Integer> implements OrderGoodsDao {

    @Override
    public boolean updateWeight(@Param("orderId") Integer orderId, @Param("weight") BigDecimal weight) {
        return baseMapper.updateWeight(orderId, weight) > 0;
    }

    @Override
    public String getMaxOrderGoodsId(String type) {
        return baseMapper.getMaxOrderGoodsId(type);
    }

    @Override
    public Optional<OrderGoods> getByOrderGoodsNo(String orderGoodsNo) {
        return Optional.of(orderGoodsNo)
                .map(item -> lQrWrapper()
                        .eq(OrderGoods::getOrderGoodsNo, item)
                )
                .map(super::getOne);
    }

    @Override
    public Optional<OrderGoods> getOrderGoodsInfoByOrderGoodsNoForPC(String orderGoodsNo) {
        return Optional.of(orderGoodsNo)
                .map(item -> lQrWrapper()
                        .eq(OrderGoods::getOrderGoodsNo, item)
                )
                .map(super::getOne);
    }

    @Override
    public Optional<OrderGoods> getOrderGoodsInfoByOrderGoodsNoForAPP(String orderGoodsNo) {
        return Optional.of(orderGoodsNo)
                .map(item -> lQrWrapper()
                        .eq(OrderGoods::getOrderGoodsNo, item)
                )
                .map(super::getOne);
    }

    @Override
    public IPage<OrderGoodsVO> pageOrderGoodsList(PageOrderGoodsListParam param) {
        Page<OrderGoodsVO> page = Page.of(param.getPage(), param.getPageSize());
        return baseMapper.pageOrderGoodsList(page, param);
    }

    @Override
    public void updateOrderGoodsReduceWeightAndStatus(Integer id, BigDecimal orderChildWeight, Integer orderGoodsStatus) {
        baseMapper.updateOrderGoodsWeightAndStatus(id, orderChildWeight, orderGoodsStatus);
    }

    @Override
    public IPage<OrderGoodsAPPVO> openOrderPageGoodsList(OrderGoodsListPageParam param) {
        Page<OrderGoodsAPPVO> page = Page.of(param.getPage(), param.getPageSize());
        return baseMapper.openOrderPageGoodsList(page);
    }

    @Override
    public IPage<OrderGoodsAPPVO> exclusiveOrderPageGoodsList(OrderGoodsListPageParam param, List<String> orderGoodsNoList) {
        Page<OrderGoodsAPPVO> page = Page.of(param.getPage(), param.getPageSize());

        return baseMapper.exclusiveOrderPageGoodsList(page, orderGoodsNoList);
    }

    @Override
    public void updateOrderGoodsStatusByOrderGoodsNo(String orderGoodsNo, Integer code) {
        baseMapper.updateOrderGoodsStatusByOrderGoodsNo(orderGoodsNo, code);
    }

    @Override
    public void saveBatchEntity(List<OrderGoods> orderGoodsList) {
        baseMapper.saveBatchEntity(orderGoodsList);
    }

    @Override
    public List<OrderGoods> getOrderGoodsListByOrderNo(String orderNo) {
        return baseMapper.selectList(lQrWrapper().eq(OrderGoods::getOrderNo, orderNo));
    }

    @Override
    public List<OrderGoods> getOrderGoodsListByOrderNoAndLastArriveSendTime(String orderNo, LocalDateTime lastArriveSendTime) {
        return baseMapper.selectList(lQrWrapper().eq(OrderGoods::getOrderNo, orderNo)
                        .eq(OrderGoods::getOrderGoodsStatus, OrderGoodsStatusEnum.Status.SUCCESS.getCode())
                .le(OrderGoods::getLastArriveSendTime, lastArriveSendTime)

        );

    }

    @Override
    public Optional<List<OrderGoods>> getOrderGoodsList() {
        return Optional.ofEmpty(list(lQrWrapper()
                .eq(OrderGoods::getOrderGoodsStatus, OrderGoodsStatusEnum.Status.CREATED.getCode())
                .eq(OrderGoods::getOrderGoodsStatus, OrderGoodsStatusEnum.Status.PAYING.getCode())
                .eq(OrderGoods::getOrderGoodsStatus, OrderGoodsStatusEnum.Status.GO_TO_SEND.getCode())
                .eq(OrderGoods::getOrderGoodsStatus, OrderGoodsStatusEnum.Status.SUCCESS.getCode())
        ));
    }


}
