package com.clx.performance.dao;

import com.clx.performance.mapper.OrderGoodsTruckBindMapper;
import com.clx.performance.model.OrderGoodsTruckBind;
import com.msl.common.base.Optional;
import com.msl.common.dao.BaseDao;

import java.time.LocalDateTime;
import java.util.List;

/**
 * @Author: huyufan
 * @Description: 货单定向绑定车辆表
 * @Date: 2023/09/18 11:34:50
 * @Version: 1.0
 */
public interface OrderGoodsTruckBindDao extends BaseDao<OrderGoodsTruckBindMapper, OrderGoodsTruckBind, Integer> {

    void saveBatchEntity(String orderNo, String orderGoodsNo, List<String> trackList, LocalDateTime now);

    boolean updateStatus(OrderGoodsTruckBind item);


    List<Integer> getTrucksByOrderGoodsNo(String orderGoodsNo);
    Optional<OrderGoodsTruckBind> getByOrderGoodsNoAndTruckNo(String orderGoodsNo, String truckNo);
    Optional<OrderGoodsTruckBind> getValidByOrderGoodsNoAndTruckNo(String truckNo);
    Optional<List<OrderGoodsTruckBind>> getValidByTruckNo(String truckNo);

    Optional<List<OrderGoodsTruckBind>> selectListByTruckNo(List<String> truckList);
}
