package com.clx.performance.model.loan;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @author kavin
 * Date 2024-01-20
 * Time 13:31
 */
@Getter
@Setter
@Accessors(chain = true)
@TableName("owner_loan_account")
public class OwnerLoanAccount implements HasKey<Integer> {

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @TableField("owner_user_no")
    @ApiModelProperty("货主编码")
    private Long ownerUserNo;

    @TableField("owner_user_name")
    @ApiModelProperty("货主名称")
    private String ownerUserName;

    @TableField("mobile")
    @ApiModelProperty("联系电话")
    private String mobile;

    @TableField("account_type")
    @ApiModelProperty("账户类型： 默认3 借款账户")
    private Integer accountType;

    @TableField("funding_account_balance")
    @ApiModelProperty("资金账户金额")
    private BigDecimal fundingAccountBalance;

    @TableField("funding_usable_balance")
    @ApiModelProperty("资金可用金额")
    private BigDecimal fundingUsableBalance;

    @TableField("funding_frozen_balance")
    @ApiModelProperty("资金冻结金额")
    private BigDecimal fundingFrozenBalance;

    @TableField("virtually_account_balance")
    @ApiModelProperty("虚拟币账户金额")
    private BigDecimal virtuallyAccountBalance;

    @TableField("virtually_usable_balance")
    @ApiModelProperty("虚拟币可用余额")
    private BigDecimal virtuallyUsableBalance;

    @TableField("virtually_frozen_balance")
    @ApiModelProperty("虚拟币冻结余额")
    private BigDecimal virtuallyFrozenBalance;

    @TableField("funding_arrears")
    @ApiModelProperty("资金欠款")
    private BigDecimal fundingArrears;

    @TableField("virtually_arrears")
    @ApiModelProperty("虚拟币欠款")
    private BigDecimal virtuallyArrears;

    @TableField("create_by")
    @ApiModelProperty("创建人")
    private String createBy;

    @TableField("create_time")
    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;

    @TableField("modified_time")
    @ApiModelProperty("修改时间")
    private LocalDateTime modifiedTime;

    @Override
    @KeyColumn("id")
    public Integer gainKey() {
        return this.id;
    }
}
