package com.clx.performance.controller.app;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.param.app.*;
import com.clx.performance.service.OrderChildService;
import com.clx.performance.vo.app.*;
import com.msl.common.base.PageData;
import com.msl.common.base.PageParam;
import com.msl.common.convertor.aspect.UnitCovert;
import com.msl.common.result.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * @Author: aiqingguo
 * @Description: 运单
 * @Date: 2023-8-21 12:10:16
 * @Version: 1.0
 */

@Slf4j
@RestController
@RequestMapping(value="/app/driver/orderChild")
@Validated
@Api(tags = "APP-运单")
@AllArgsConstructor
public class AppDriverOrderChildController {

    private final OrderChildService orderChildService;

    @ApiOperation(value = "接单判断", notes = "<br>By:胡宇帆")
    @PostMapping("/getOrderChildCheck")
    public Result<String> getOrderChildCheck(@RequestBody @Validated OrderChildCheckParam param) {

        return Result.ok(orderChildService.getOrderChildCheck(param));
    }

    @ApiOperation(value = "接单", notes = "<br>By:艾庆国")
    @PostMapping("/saveOrderChild")
    public Result<SaveOrderChildVO> saveOrderChild(@RequestBody @Validated OrderChildSaveParam param) {

        return Result.ok(orderChildService.saveOrderChild(param));
    }

    @ApiOperation(value = "拒绝接单(专属货单)", notes = "<br>By:艾庆国")
    @PostMapping("/updateReject")
    public Result<Void> updateReject(@RequestBody @Validated OrderChildRejectParam param) {
        orderChildService.updateReject(param);

        return Result.ok();
    }

    @ApiOperation(value = "前往货源地", notes = "<br>By:艾庆国")
    @PostMapping("/updateGotoSendAddress")
    public Result<Void> updateGotoSendAddress(@RequestBody @Validated OrderChildGoToSendAddressParam param) {
        orderChildService.updateGotoSendAddress(param);

        return Result.ok();
    }

    @ApiOperation(value = "到达货源地", notes = "<br>By:艾庆国")
    @PostMapping("/updateArriveSendAddress")
    public Result<Void> updateArriveSendAddress(@RequestBody @Validated OrderChildArriveSendAddressParam param) {
        orderChildService.updateArriveSendAddress(param);

        return Result.ok();
    }


    @ApiOperation(value = "前往目的地", notes = "<br>By:艾庆国")
    @PostMapping("/updateGotoReceiveAddress")
    public Result<Void> updateGotoReceiveAddress(@RequestBody @Validated OrderChildGoToReceiveAddressParam param) {
        orderChildService.updateGotoReceiveAddress(param);

        return Result.ok();
    }

    @ApiOperation(value = "到达目的地", notes = "<br>By:艾庆国")
    @PostMapping("/updateArriveReceiveAddress")
    public Result<Void> updateArriveReceiveAddress(@RequestBody @Validated OrderChildArriveReceiveAddressParam param) {
        orderChildService.updateArriveReceiveAddress(param);

        return Result.ok();
    }

    @ApiOperation(value = "装车(首次、重复)", notes = "<br>By:艾庆国")
    @PostMapping("/updateLoad")
    public Result<Void> updateLoad(@RequestBody @Validated OrderChildLoadParam param) {
        orderChildService.updateLoad(param);

        return Result.ok();
    }

    @ApiOperation(value = "卸车(首次、重复)", notes = "<br>By:艾庆国")
    @PostMapping("/updateUnload")
    public Result<Void> updateUnload(@RequestBody @Validated OrderChildUnloadParam param) {
        orderChildService.updateUnload(param);

        return Result.ok();
    }

    @ApiOperation(value = "重新装车卸车", notes = "修改装车卸车信息<br>By:艾庆国")
    @PostMapping("/updateLoadAndUnloadAgain")
    public Result<Void> updateLoadAndUnloadAgain(@RequestBody @Validated OrderChildLoadAndUnloadAgainParam param) {
        orderChildService.updateLoadAndUnloadAgain(param);

        return Result.ok();
    }

    @ApiOperation(value = "确认交货", notes = "<br>By:艾庆国")
    @PostMapping("/updateConfirm")
    public Result<Void> updateDriverConfirm(@RequestBody @Validated OrderChildDriverConfirmParam param) {
        orderChildService.updateDriverConfirm(param);

        return Result.ok();
    }

    @ApiOperation(value = "取消运单", notes = "<br>By:艾庆国")
    @PostMapping("/updateCancel")
    public Result<Void> updateDriverCancel(@RequestBody @Validated OrderChildDriverCancelParam param) {
        orderChildService.updateDriverCancel(param);

        return Result.ok();
    }

    @ApiOperation(value = "查询运单详情", notes = "<br>By:艾庆国")
    @UnitCovert(param = false)
    @GetMapping("/getOrderChildInfo")
    public Result<OrderChildVO> getOrderChildInfo(String childNo) {

        return Result.ok(orderChildService.getOrderChildInfo(childNo));
    }

    @ApiOperation(value = "分页查询运单列表",notes = "<br>By:艾庆国")
    @PostMapping("/pageOrderChild")
    @UnitCovert(param = false)
    public Result<PageData<OrderChildVO>> pageOrderChild(@RequestBody @Validated PageOrderChildOfDriverParam param) {
        IPage<OrderChildVO> page = orderChildService.pageOrderChild(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }

    @ApiOperation(value = "分页搜索运单列表",notes = "<br>By:艾庆国")
    @PostMapping("/pageSearchOrderChild")
    public Result<PageData<OrderChildVO>> pageSearchOrderChild(@RequestBody @Validated PageOrderChildOfDriverSearchParam param) {
        IPage<OrderChildVO> page = orderChildService.pageSearchOrderChild(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }

    @ApiOperation(value = "查询预估运费", notes = "<br>By:艾庆国")
    @UnitCovert(param = false)
    @PostMapping("/getEstimatedFreight")
    public Result<OrderChildEstimatedFreightVO> getEstimatedFreight(@RequestBody @Validated OrderChildEstimatedFreightParam param) {

        return Result.ok(orderChildService.getEstimatedFreight(param));
    }

    @ApiOperation(value = "查询运单磅单信息", notes = "<br>By:艾庆国")
    @UnitCovert(param = false)
    @GetMapping("/getOrderChildPoundInfo")
    public Result<OrderChildPoundInfoVO> getOrderChildPoundInfo(String childNo) {

        return Result.ok(orderChildService.getOrderChildPoundInfo(childNo));
    }

    @ApiOperation(value = "查询运单运费信息", notes = "<br>By:艾庆国")
    @UnitCovert(param = false)
    @GetMapping("/getOrderChildFreightInfo")
    public Result<OrderChildFreightInfoVO> getOrderChildFreightInfo(String childNo) {

        return Result.ok(orderChildService.getOrderChildFreightInfo(childNo));
    }


    @ApiOperation(value = "查询正在进行中的最新运单", notes = "<br>By:李瑞新")
    @GetMapping("/getGoingLatestOrderChild")
    public Result<GoingOrderChildVO> getGoingLatestOrderChild() {

        return Result.ok(orderChildService.getGoingLatestOrderChild());
    }

    @ApiOperation(value = "客诉运单列表", notes = "<br>By:刘海泉")
    @PostMapping("/pageCustomerComplaintOrderChild")
    public Result<PageData<CustomerComplaintOrderChildVO>> pageCustomerComplaintOrderChild(@RequestBody @Validated PageParam param) {
        IPage<CustomerComplaintOrderChildVO> page = orderChildService.pageCustomerComplaintOrderChild(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }

}
