package com.clx.performance.param.app.collect;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.List;

@Getter
@Setter
@NoArgsConstructor
public class CollectTruckRefuelSaveParam {

    @ApiModelProperty(value = "运单编号", example = "10000000000")
    @NotBlank(message = "运单编号不能为空")
    private String childNo;

    @ApiModelProperty(value = "装车油表图片列表")
    @NotEmpty(message = "装车油表图片不能为空")
    private List<String> loadImageList;
    @ApiModelProperty(value = "卸车油表图片列表")
    @NotEmpty(message = "卸车油表图片不能为空")
    private List<String> unloadImageList;

    @ApiModelProperty(value = "装车油量", example = "1.23")
    private BigDecimal loadOil;
    @ApiModelProperty(value = "卸车油量", example = "1.23")
    private BigDecimal unloadOil;

}
