package com.clx.performance.param.app.collect;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.List;

@Getter
@Setter
@NoArgsConstructor
public class CollectTrafficCongestionSaveParam {

    @ApiModelProperty(value = "经度")
    private BigDecimal longitude;
    @ApiModelProperty(value = "纬度")
    private BigDecimal latitude;

    @ApiModelProperty(value = "省", example = "")
    private String province;
    @ApiModelProperty(value = "市", example = "")
    private String city;
    @ApiModelProperty(value = "区县", example = "")
    private String county;
    @ApiModelProperty(value = "乡镇", example = "")
    private String town;
    @ApiModelProperty(value = "街道", example = "")
    private String street;
    @ApiModelProperty(value = "详细地址", example = "北京路1号")
    private String address;

    @ApiModelProperty(value = "预计拥堵时长（小时）", example = "1.5")
    private BigDecimal jamTime;
    @ApiModelProperty(value = "现场照片列表")
    private List<String> jamImageList;


}
