package com.clx.performance.param.app;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

@Getter
@Setter
@NoArgsConstructor
public class OrderChildCheckParam extends PositionParam {

    @ApiModelProperty(value = "货单编号", example = "100000000")
    @NotBlank(message = "货单编号不能为空")
    private String orderGoodsNo;

    @ApiModelProperty(value = "车辆id", example = "1")
    @NotNull(message = "车辆id空")
    private Integer truckId;

    @ApiModelProperty(value = "车牌号", example = "1")
    @NotNull(message = "车牌号不能为空")
    private String truckNo;

    @ApiModelProperty(value = "司机用户编号", example = "1")
    @NotNull(message = "司机用户编号空")
    private Long driverUserNo;

    @ApiModelProperty("纬度")
    private BigDecimal latitude;

    @ApiModelProperty("经度")
    private BigDecimal longitude;

    @ApiModelProperty("可卸车时间段开始")
    private String unloadBeginTime;

    @ApiModelProperty("可卸车时间段结束")
    private String unloadEndTime;
}
