package com.clx.performance.model.collect;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

import java.time.LocalDateTime;

/**
* @Author: aiqinguo
* @Description: 司机请假表
* @Date: 2023/10/16 13:06:26
* @Version: 1.0
*/

@Getter
@Setter
@NoArgsConstructor
@TableName(autoResultMap = true)
public class CollectTruckLeave implements HasKey<Integer> {

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;                             //id
    private Long userNo;                            //用户编号
    private String name;                            //用户姓名
    private String mobile;                          //手机号码
    private String truckNo;                         //车牌号
    private LocalDateTime beginTime;                //请假开始时间
    private LocalDateTime endTime;                  //请假结束时间
    private String remark;                          //请假原因
    private LocalDateTime reportTime;               //上报时间
    private LocalDateTime createTime;               //创建时间
    private LocalDateTime modifiedTime;             //修改时间

    @KeyColumn("id")
    @Override
    public Integer gainKey() {
        return id;
    }

}