package com.clx.performance.dao.impl;

import com.clx.performance.dao.PlatformServiceFeeConfigDao;
import com.clx.performance.mapper.PlatformServiceFeeConfigMapper;
import com.clx.performance.model.PlatformServiceFeeConfig;
import com.msl.common.dao.impl.BaseDaoImpl;
import org.springframework.stereotype.Repository;


/**
 * @author yangqifa
 */
@Repository
public class PlatformServiceFeeConfigImpl extends BaseDaoImpl<PlatformServiceFeeConfigMapper, PlatformServiceFeeConfig, Integer> implements PlatformServiceFeeConfigDao {

    @Override
    public PlatformServiceFeeConfig listPlatformServiceFeeConfig() {
        return list().get(0);
    }

    @Override
    public boolean updatePlatformServiceFeeConfig(PlatformServiceFeeConfig config) {
        return update(lUdWrapper()
                .eq(PlatformServiceFeeConfig::getId, config.getId())
                .set(PlatformServiceFeeConfig::getOrderQuotationType, config.getOrderQuotationType())
                .set(PlatformServiceFeeConfig::getDeposit, config.getDeposit())
                .set(PlatformServiceFeeConfig::getServiceFeeRate, config.getServiceFeeRate())
        );
    }
}
