package com.clx.performance.controller.temp;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.clx.performance.service.TempService;
import com.clx.performance.utils.LocalDateTimeUtils;
import com.clx.performance.vo.pc.child.OrderChildLineStatisticsVO;
import com.msl.common.result.Result;
import com.nbopen.api.*;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;


/**
 * @Author: aiqingguo
 * @Description: 临时接口
 * @Date: 2023-8-21 12:10:16
 * @Version: 1.0
 */
@Slf4j
@RestController
@RequestMapping(value="/temp/yftbank")
public class TempYftBankController {

    @Autowired
    private TempService tempService;

    @ApiOperation(value = "test", notes = "<br>By:艾庆国")
    @RequestMapping(value = "/test", method = RequestMethod.POST)
    public Result<OrderChildLineStatisticsVO> test() throws Exception {

        bankTest();


        return Result.ok();
    }


    public static void bankTest() throws Exception {
        ClassPathResource classPathResource = new ClassPathResource("bank/config-nbbank.json");
        InputStream inputStream = null;
        try {
            inputStream = classPathResource.getInputStream();
            boolean initResult = NBOpenSDK.init(inputStream);
            log.info("NBSDK初始化状态:{}", initResult);
            log.info("sdk版本信息:{}", NBOpenSDK.getVersionInfo());
        } catch (IOException e) {
            e.printStackTrace();
        }

        testAPI();
    }

    //API测试接口

    /**
     * 商户号：EFT33021200556315
     * 银行转账：86041110000075918（户名：客户客户）
     * 订单支付：结算账号（86041110000075926（户名：客户客户））
     */
    private static void testAPI() {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("transId", "IP01");      //交易识别码 必填
            jsonObject.put("merId", "EFT33021200556315");     //商户号 必填

            jsonObject.put("merSeqNo", LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss")));     //商户流水 必填
            jsonObject.put("merDtTm", LocalDateTimeUtils.formatTime());     //商户时间 必填

            jsonObject.put("trxAmt", "1.23");     //订单金额 必填
            jsonObject.put("orderDesc", "采购");     //订单详情 必填
            jsonObject.put("productName", "小黄鱼");     //商品名称 必填
            jsonObject.put("productId", "001");     //商品编号 必填
            jsonObject.put("productNum", "1");     //商品数量 必填

            jsonObject.put("payAcctNo", "86041110000075926");     //付款账号 必填
            jsonObject.put("payAcctNm", "客户客户");     //付款户名 必填
            jsonObject.put("bankType", "00");     //账户类型 必填
            jsonObject.put("payAcctOpenBankId", "313332082914");     //开户行号 必填
//        jsonObject.put("mobilePhone", "13000000000");     //手机号

            HashMap<String,String> httpHeader = new HashMap<>();


            RequestApiData requestApiData = new RequestApiData();
            requestApiData.setAppkey("77667c76_3503_4c04_95f7_fc10938c7942");
            requestApiData.setData(jsonObject);
            requestApiData.setProductId("YFT");
            requestApiData.setServiceId("unionPayDirectOrder");
            requestApiData.setHttpHeader(httpHeader);

            RequestHead requestHead = new RequestHead();
            requestHead.setRqsJrnlNo(NBOpenSDK.getRandom());

            SDKRequest request = new SDKRequest();
            request.setData(requestApiData);
            request.setHead(requestHead);

            log.info("SDK请求内容: "+ JSON.toJSONString(request));
            SDKResponse result = NBOpenSDK.send(request);
            log.info("SDK响应结果: "+JSON.toJSONString(result));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
//
//    //文件上传测试接口
//    private static void testUploadFile(String localFileName,String remoteFileName,String tranCode) throws Exception {
//        try{
//            SDKRequest request = new SDKRequest();
//            RequestHead head = new RequestHead();
//            head.setRqsJrnlNo(NBOpenSDK.getRandom());
//            request.setHead(head);
//            RequestFileData fileData = new RequestFileData();
//            fileData.setLocalFilePath("C:\\Users\\k6118\\Downloads\\11.json");
//            fileData.setRemoteFileName("11.json");
//            fileData.setTranCode("merFileUploadApply");
//            fileData.setUid("YITANG");
//            request.setData(fileData);
//            System.out.println("---SDK请求报文: "+ JSON.toJSONString(request, SerializerFeature.WriteMapNullValue));
//            SDKResponse response = NBOpenSDK.putFile(request);
//            System.out.println( "---SDK响应结果: "+ JSON.toJSONString(response,SerializerFeature.WriteMapNullValue));
//        } catch (Exception e){
//            e.printStackTrace();
//        }
//    }
//
//    //文件下载测试接口
//    private static void testDownloadFile(String localFileName,String remoteFileName,String tranCode) throws Exception {
//        try{
//            SDKRequest request = new SDKRequest();
//            RequestHead head = new RequestHead();
//            head.setRqsJrnlNo(NBOpenSDK.getRandom());
//            request.setHead(head);
//            RequestFileData fileData = new RequestFileData();
//            fileData.setLocalFilePath("C:\\Users\\k6118\\Downloads\\12.json");
//            fileData.setRemoteFileName("8374eb1718cf4083a74430ebd9af058f/11.json");
//            fileData.setTranCode("merFileDownloadApply");
//            fileData.setUid("YITANG");
//            request.setData(fileData);
//            System.out.println("---SDK请求报文: "+ JSON.toJSONString(request, SerializerFeature.WriteMapNullValue));
//            SDKResponse response = NBOpenSDK.getFile(request);
//            System.out.println( "---SDK响应结果: "+ JSON.toJSONString(response,SerializerFeature.WriteMapNullValue));
//        } catch (Exception e){
//            e.printStackTrace();
//        }
//    }
//
//    /**
//     * 易付通
//     */
//    static String unionPayDirectOrder() throws Exception {
//
//        HashMap<String, Object> map = new HashMap();
//        HashMap<String, Object> data = new HashMap();
//        map.put("Data", data);
//
//        data.put("transId", "IP01");      //交易识别码 必填
//        data.put("merId", "2023112300000002");     //商户号 必填
//        data.put("merSeqNo", "2023112300000001");     //商户流水 必填
//        data.put("merDtTm", "2023-11-24 11:00:00");     //商户时间 必填
//        data.put("trxAmt", "1.23");     //订单金额 必填
//        data.put("orderDesc", "采购");     //订单详情 必填
//        data.put("productNam", "小黄鱼");     //商品名称 必填
//        data.put("productId", "001");     //商品编号 必填
//        data.put("productNum", "1");     //商品数量 必填
//
//        data.put("payAcctNo", "6223161100110442");     //付款账号 必填
//        data.put("payAcctNm", "刘晓琴");     //付款户名 必填
//        data.put("bankType", "00");     //账户类型 必填
//        data.put("payAcctOpenBankId", "313332082914");     //开户行号 必填
////        data.put("mobilePhone", "13000000000");     //手机号
//
//        String res1 = NBOpenSDK.send("YFT", "unionPayDirectOrder", JSON.toJSONString(map));
//        log.info("银联订单支付收款模式接口：{}" , res1);
//
//        return res1;
//    }
//
//
    public static void main(String[] args) throws Exception {

        bankTest();

    }


}
