package com.clx.performance.controller.temp;

import com.clx.performance.service.TempService;
import com.clx.performance.service.child.FeignOrderChildService;
import com.clx.performance.vo.pc.child.OrderChildLineStatisticsVO;
import com.msl.common.result.Result;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.constraints.NotBlank;


/**
 * @Author: aiqingguo
 * @Description: 临时接口
 * @Date: 2023-8-21 12:10:16
 * @Version: 1.0
 */
@Slf4j
@RestController
@RequestMapping(value="/temp")
public class TempController {

    @Autowired
    private TempService tempService;
    @Autowired
    private FeignOrderChildService carrierOrderChildService;



    @ApiOperation(value = "test", notes = "<br>By:艾庆国")
    @RequestMapping(value = "/test", method = RequestMethod.POST)
    public Result<OrderChildLineStatisticsVO> test(Integer sendAddressId, Integer receiveAddressId) {

        return Result.ok(carrierOrderChildService.getLineStatistics(sendAddressId, receiveAddressId));
    }

    @ApiOperation(value = "更新网运标识", notes = "<br>By:艾庆国")
    @RequestMapping(value = "/updateInvoiceType", method = RequestMethod.POST)
    public Result<Void> updateInvoiceType(String childNo, Integer invoiceType) {

        tempService.updateInvoiceType(childNo, invoiceType);

        return Result.ok();
    }


    @ApiOperation(value = "司机违约结算单完成 (临时接口)", notes = "<br>By:艾庆国")
    @RequestMapping(value = "/updateBreakContractDriverSettlementFinish", method = RequestMethod.POST)
    public Result<Void> updateBreakContractDriverSettlementFinish(String settlementNo) {

        tempService.updateBreakContractDriverSettlementFinish(settlementNo);

        return Result.ok();
    }

    @ApiOperation(value = "测试支付划账 (临时接口)", notes = "<br>By:胡宁宁")
    @RequestMapping(value = "/paymentTest", method = RequestMethod.GET)
    public Result<Void> paymentTest(@RequestParam("fromUser") @NotBlank(message = "扣款方") String fromUser,
                                    @RequestParam("toUser") @NotBlank(message = "收款方") String toUser,
                                    @RequestParam("figure") @NotBlank(message = "金额") String figure) {

        tempService.paymentTest(fromUser,toUser,figure);

        return Result.ok();
    }

}
