/*
 * Decompiled with CFR 0.152.
 */
package com.nbcb.bouncycastle.jce;

import com.nbcb.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.nbcb.bouncycastle.asn1.x9.X9ECParameters;
import com.nbcb.bouncycastle.crypto.ec.CustomNamedCurves;
import com.nbcb.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import java.util.Enumeration;

public class ECNamedCurveTable {
    public static ECNamedCurveParameterSpec getParameterSpec(String name) {
        X9ECParameters ecP = CustomNamedCurves.getByName(name);
        if (ecP == null) {
            try {
                ecP = CustomNamedCurves.getByOID(new ASN1ObjectIdentifier(name));
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            if (ecP == null && (ecP = com.nbcb.bouncycastle.asn1.x9.ECNamedCurveTable.getByName(name)) == null) {
                try {
                    ecP = com.nbcb.bouncycastle.asn1.x9.ECNamedCurveTable.getByOID(new ASN1ObjectIdentifier(name));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        if (ecP == null) {
            return null;
        }
        return new ECNamedCurveParameterSpec(name, ecP.getCurve(), ecP.getG(), ecP.getN(), ecP.getH(), ecP.getSeed());
    }

    public static Enumeration getNames() {
        return com.nbcb.bouncycastle.asn1.x9.ECNamedCurveTable.getNames();
    }
}

