/*
 * Decompiled with CFR 0.152.
 */
package com.nbcb.bouncycastle.crypto.tls;

import com.nbcb.bouncycastle.crypto.Digest;
import com.nbcb.bouncycastle.crypto.Signer;
import com.nbcb.bouncycastle.crypto.params.DHParameters;
import com.nbcb.bouncycastle.crypto.tls.DigestInputBuffer;
import com.nbcb.bouncycastle.crypto.tls.DigitallySigned;
import com.nbcb.bouncycastle.crypto.tls.SecurityParameters;
import com.nbcb.bouncycastle.crypto.tls.ServerDHParams;
import com.nbcb.bouncycastle.crypto.tls.SignatureAndHashAlgorithm;
import com.nbcb.bouncycastle.crypto.tls.SignerInputBuffer;
import com.nbcb.bouncycastle.crypto.tls.TlsCredentials;
import com.nbcb.bouncycastle.crypto.tls.TlsDHKeyExchange;
import com.nbcb.bouncycastle.crypto.tls.TlsDHUtils;
import com.nbcb.bouncycastle.crypto.tls.TlsFatalAlert;
import com.nbcb.bouncycastle.crypto.tls.TlsSigner;
import com.nbcb.bouncycastle.crypto.tls.TlsSignerCredentials;
import com.nbcb.bouncycastle.crypto.tls.TlsUtils;
import com.nbcb.bouncycastle.util.io.TeeInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public class TlsDHEKeyExchange
extends TlsDHKeyExchange {
    protected TlsSignerCredentials serverCredentials = null;

    public TlsDHEKeyExchange(int keyExchange, Vector supportedSignatureAlgorithms, DHParameters dhParameters) {
        super(keyExchange, supportedSignatureAlgorithms, dhParameters);
    }

    @Override
    public void processServerCredentials(TlsCredentials serverCredentials) throws IOException {
        if (!(serverCredentials instanceof TlsSignerCredentials)) {
            throw new TlsFatalAlert(80);
        }
        this.processServerCertificate(serverCredentials.getCertificate());
        this.serverCredentials = (TlsSignerCredentials)serverCredentials;
    }

    @Override
    public byte[] generateServerKeyExchange() throws IOException {
        if (this.dhParameters == null) {
            throw new TlsFatalAlert(80);
        }
        DigestInputBuffer buf = new DigestInputBuffer();
        this.dhAgreePrivateKey = TlsDHUtils.generateEphemeralServerKeyExchange(this.context.getSecureRandom(), this.dhParameters, buf);
        SignatureAndHashAlgorithm signatureAndHashAlgorithm = TlsUtils.getSignatureAndHashAlgorithm(this.context, this.serverCredentials);
        Digest d = TlsUtils.createHash(signatureAndHashAlgorithm);
        SecurityParameters securityParameters = this.context.getSecurityParameters();
        d.update(securityParameters.clientRandom, 0, securityParameters.clientRandom.length);
        d.update(securityParameters.serverRandom, 0, securityParameters.serverRandom.length);
        buf.updateDigest(d);
        byte[] hash = new byte[d.getDigestSize()];
        d.doFinal(hash, 0);
        byte[] signature = this.serverCredentials.generateCertificateSignature(hash);
        DigitallySigned signed_params = new DigitallySigned(signatureAndHashAlgorithm, signature);
        signed_params.encode(buf);
        return buf.toByteArray();
    }

    @Override
    public void processServerKeyExchange(InputStream input) throws IOException {
        SecurityParameters securityParameters = this.context.getSecurityParameters();
        SignerInputBuffer buf = new SignerInputBuffer();
        TeeInputStream teeIn = new TeeInputStream(input, buf);
        ServerDHParams dhParams = ServerDHParams.parse(teeIn);
        DigitallySigned signed_params = this.parseSignature(input);
        Signer signer = this.initVerifyer(this.tlsSigner, signed_params.getAlgorithm(), securityParameters);
        buf.updateSigner(signer);
        if (!signer.verifySignature(signed_params.getSignature())) {
            throw new TlsFatalAlert(51);
        }
        this.dhAgreePublicKey = TlsDHUtils.validateDHPublicKey(dhParams.getPublicKey());
        this.dhParameters = this.validateDHParameters(this.dhAgreePublicKey.getParameters());
    }

    protected Signer initVerifyer(TlsSigner tlsSigner, SignatureAndHashAlgorithm algorithm, SecurityParameters securityParameters) {
        Signer signer = tlsSigner.createVerifyer(algorithm, this.serverPublicKey);
        signer.update(securityParameters.clientRandom, 0, securityParameters.clientRandom.length);
        signer.update(securityParameters.serverRandom, 0, securityParameters.serverRandom.length);
        return signer;
    }
}

