/*
 * Decompiled with CFR 0.152.
 */
package com.nbcb.bouncycastle.asn1;

import com.nbcb.bouncycastle.asn1.ASN1InputStream;
import com.nbcb.bouncycastle.asn1.LimitedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;

class StreamUtil {
    private static final long MAX_MEMORY = Runtime.getRuntime().maxMemory();

    StreamUtil() {
    }

    static int findLimit(InputStream in) {
        if (in instanceof LimitedInputStream) {
            return ((LimitedInputStream)in).getRemaining();
        }
        if (in instanceof ASN1InputStream) {
            return ((ASN1InputStream)in).getLimit();
        }
        if (in instanceof ByteArrayInputStream) {
            return ((ByteArrayInputStream)in).available();
        }
        if (in instanceof FileInputStream) {
            try {
                long size;
                FileChannel channel = ((FileInputStream)in).getChannel();
                long l = size = channel != null ? channel.size() : Integer.MAX_VALUE;
                if (size < Integer.MAX_VALUE) {
                    return (int)size;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (MAX_MEMORY > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)MAX_MEMORY;
    }

    static int calculateBodyLength(int length) {
        int count = 1;
        if (length > 127) {
            int size = 1;
            int val = length;
            while ((val >>>= 8) != 0) {
                ++size;
            }
            for (int i = (size - 1) * 8; i >= 0; i -= 8) {
                ++count;
            }
        }
        return count;
    }

    static int calculateTagLength(int tagNo) throws IOException {
        int length = 1;
        if (tagNo >= 31) {
            if (tagNo < 128) {
                ++length;
            } else {
                byte[] stack = new byte[5];
                int pos = stack.length;
                stack[--pos] = (byte)(tagNo & 0x7F);
                do {
                    stack[--pos] = (byte)((tagNo >>= 7) & 0x7F | 0x80);
                } while (tagNo > 127);
                length += stack.length - pos;
            }
        }
        return length;
    }
}

