package com.clx.performance.controller.temp;

import com.clx.open.sdk.callback.message.OrderChildSyncMessage;
import com.clx.performance.dto.OrderChildExpectDTO;
import com.clx.performance.extranal.transport.TransportService;
import com.clx.performance.feign.TransportFeignService;
import com.clx.performance.listener.OrderChildDtsListener;
import com.clx.performance.service.OrderChildService;
import com.clx.performance.service.TempService;
import com.clx.performance.service.child.FeignOrderChildService;
import com.msl.common.result.Result;
import com.msl.common.utils.DateUtils;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.validation.constraints.NotBlank;
import java.time.LocalDateTime;

/**
 * @Author: aiqingguo
 * @Description: 临时接口
 * @Date: 2023-8-21 12:10:16
 * @Version: 1.0
 */
@Slf4j
@RestController
@RequestMapping(value="/temp")
public class TempController {

    @Autowired
    private TempService tempService;
    @Autowired
    private FeignOrderChildService carrierOrderChildService;
    @Autowired
    private TransportService transportService;
    @Autowired
    private TransportFeignService transportFeignService;
    @Autowired
    OrderChildDtsListener orderChildDtsListener;

    @Autowired
    private OrderChildService orderChildService;


    @ApiOperation(value = "test", notes = "<br>By:艾庆国")
    @RequestMapping(value = "/test", method = RequestMethod.GET)
    public Result test() {

        OrderChildSyncMessage message = new OrderChildSyncMessage();
        message.setId(1);
        orderChildDtsListener.thirdpartySync(message);

        return Result.ok();
    }

    @ApiOperation(value = "测试支付划账 (临时接口)", notes = "<br>By:胡宁宁")
    @RequestMapping(value = "/paymentTest", method = RequestMethod.GET)
    public Result<Void> paymentTest(@RequestParam("fromUser") @NotBlank(message = "扣款方") String fromUser,
                                    @RequestParam("pwd") @NotBlank(message = "收款方") String pwd,
                                    @RequestParam("tradeNo") @NotBlank(message = "金额") String tradeNo,
                                    @RequestParam("type") @NotBlank(message = "类型") int type) {

        tempService.paymentTest(fromUser,pwd,tradeNo,type);

        return Result.ok();
    }





    @ApiOperation(value = "插入缓存运单预计时间", notes = "<br>By:刘海泉")
    @RequestMapping(value = "/saveOrderChildExpectTime", method = RequestMethod.GET)
    public Result<Void> saveOrderChildExpectTime(@RequestParam("childNo") @NotBlank(message = "运单号不能为空") String childNo,
            @RequestParam("expectArriveTime") @NotBlank(message = "预计到达货源地时间") String expectArriveTime,
            @RequestParam("expectReceiveTime") @NotBlank(message = "预计到达目的地时间") String expectReceiveTime) {
        OrderChildExpectDTO expect = new OrderChildExpectDTO();
        expect.setChildNo(childNo);
        expect.setExpectArriveTime(expectArriveTime);
        expect.setExpectReceiveTime(expectReceiveTime);
        expect.setCreateTime(DateUtils.formatDateTime(LocalDateTime.now()).get());
        orderChildService.cacheOrderChildExpectData(childNo,expect);


        return Result.ok();
    }

//    @ApiOperation(value = "更新网运标识", notes = "<br>By:艾庆国")
//    @RequestMapping(value = "/updateInvoiceType", method = RequestMethod.POST)
//    public Result<Void> updateInvoiceType(String childNo, Integer invoiceType) {
//
//        tempService.updateInvoiceType(childNo, invoiceType);
//
//        return Result.ok();
//    }


//    @ApiOperation(value = "司机违约结算单完成 (临时接口)", notes = "<br>By:艾庆国")
//    @RequestMapping(value = "/updateBreakContractDriverSettlementFinish", method = RequestMethod.POST)
//    public Result<Void> updateBreakContractDriverSettlementFinish(String settlementNo) {
//
//        tempService.updateBreakContractDriverSettlementFinish(settlementNo);
//
//        return Result.ok();
//    }

//    @ApiOperation(value = "测试支付划账 (临时接口)", notes = "<br>By:胡宁宁")
//    @RequestMapping(value = "/paymentTest", method = RequestMethod.GET)
//    public Result<Void> paymentTest(@RequestParam("fromUser") @NotBlank(message = "扣款方") String fromUser,
//                                    @RequestParam("toUser") @NotBlank(message = "收款方") String toUser,
//                                    @RequestParam("figure") @NotBlank(message = "金额") String figure) {
//
//        tempService.paymentTest(fromUser,toUser,figure);
//
//        return Result.ok();
//    }


//    @ApiOperation(value = "承运同步网络货运 (临时接口)", notes = "<br>By:艾庆国")
//    @RequestMapping(value = "/orderChildSync", method = RequestMethod.GET)
//    public Result<Void> orderChildSync(@RequestBody ThirdOrderChildBrokerParam param1) {
//        ThirdOrderChildBrokerParam param = new ThirdOrderChildBrokerParam();
//        param.setChildNo("123");
//
//        transportService.orderChildSync(param);
//
//        return Result.ok();
//    }

//    @ApiOperation(value = "运单支付运费同步 (临时接口)", notes = "<br>By:艾庆国")
//    @RequestMapping(value = "/orderChildPaySync", method = RequestMethod.POST)
//    public Result<Void> orderChildPaySync(@RequestBody OrderChildPaySyncParam param) {
//
//        HttpDTO httpDTO = transportFeignService.orderChildPaySync(param);
//        String decrypt = ThirdComponent.decrypt(httpDTO.getData());
//        log.info("{}", decrypt);
//        return Result.ok();
//    }

//    @ApiOperation(value = "货主结算单同步 (临时接口)", notes = "<br>By:艾庆国")
//    @RequestMapping(value = "/ownerSettlementSync", method = RequestMethod.POST)
//    public Result<Void> ownerSettlementSync(@RequestBody OwnerSettlementSyncParam param) {
//
//        HttpDTO httpDTO = transportFeignService.ownerSettlementSync(param);
//        String decrypt = ThirdComponent.decrypt(httpDTO.getData());
//        log.info("{}", decrypt);
//        return Result.ok();
//    }

//    @ApiOperation(value = "获取风控状态 (临时接口)", notes = "<br>By:艾庆国")
//    @RequestMapping(value = "/getRiskStatus", method = RequestMethod.POST)
//    public Result<Void> getRiskStatus(String childNo) {
//        ThirdOrderChildRiskStatusParam param = ThirdOrderChildRiskStatusParam.builder().build();
//        param.setChildNo(childNo);
//        HttpDTO httpDTO = transportFeignService.getRiskStatus(param);
//        String decrypt = ThirdComponent.decrypt(httpDTO.getData());
//        log.info("{}", decrypt);
//        return Result.ok();
//    }

}
