package com.clx.performance.vo.pc.carrier.settle;

import com.msl.common.convertor.type.MoneyOutConvert;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDateTime;
import java.math.BigDecimal;

/**
* @Author: aiqinguo
* @Description: 平台服务费
* @Date: 2024/06/18 15:10:40
* @Version: 1.0
*/

@Getter
@Setter
@ToString
@NoArgsConstructor
public class SettlementPlatformServiceFeeVO {

    @ApiModelProperty(value = "id", example = "")
    private Integer id;
    @ApiModelProperty(value = "运单编号", example = "")
    private String childNo;
    @ApiModelProperty(value = "车主用户编号", example = "")
    private Long driverUserNo;
    @ApiModelProperty(value = "车主名称", example = "")
    private String driverName;
    @ApiModelProperty(value = "司机手机号", example = "")
    private String driverMobile;
    @ApiModelProperty(value = "发货地址id", example = "")
    private Integer sendAddressId;
    @ApiModelProperty(value = "发货地址", example = "")
    private String sendAddress;
    @ApiModelProperty(value = "收货地址id", example = "")
    private Integer receiveAddressId;
    @ApiModelProperty(value = "收货地址", example = "")
    private String receiveAddress;
    @ApiModelProperty(value = "车牌号", example = "")
    private String truckNo;
    @MoneyOutConvert
    @ApiModelProperty(value = "结算金额（分）", example = "")
    private BigDecimal settlementFreight;
    @MoneyOutConvert
    @ApiModelProperty(value = "开票服务费（分）", example = "")
    private BigDecimal invoiceServiceFee;
    @ApiModelProperty(value = "开票服务率%", example = "")
    private BigDecimal invoiceServiceFeeRate;
    @ApiModelProperty(value = "创建时间", example = "")
    private String createTime;

}