package com.clx.performance;

import com.clx.order.feign.OrderFeign;
import com.clx.order.param.feign.UpdateOrderInfoResidueWeightParam;
import com.clx.performance.component.OrderGoodsStatusLazyComponent;
import com.clx.performance.constant.RabbitKeyConstants;
import com.clx.performance.constant.RedisConstants;
import com.clx.performance.dao.OrderGoodsDao;
import com.clx.performance.mapper.OrderGoodsMapper;
import com.clx.performance.model.OrderGoods;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageBuilder;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.test.context.junit4.SpringRunner;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Set;

@SpringBootTest
@RunWith(SpringRunner.class)
public class JobTest {

    @Autowired
    private OrderFeign orderFeign;

    @Autowired
    private RabbitTemplate rabbitTemplate;

    @Autowired
    private StringRedisTemplate stringRedisTemplate;

    @Autowired
    private OrderGoodsStatusLazyComponent orderGoodsStatusLazyComponent;

    @Autowired
    private OrderGoodsDao orderGoodsDao;
    @Test
    public void test1() {
        List<OrderGoods> list = orderGoodsDao.getOrderGoodsListByOrderNoAndLastArriveSendTime("PT2023092700023", LocalDateTime.now());
        BigDecimal childSum = list.stream().map(OrderGoods::getExtractWeight).reduce(BigDecimal.ZERO, BigDecimal::add);
        System.out.println();


//                UpdateOrderInfoResidueWeightParam param = new UpdateOrderInfoResidueWeightParam();
//        param.setOrderId(150);
//        param.setUpdateType("1");
//        param.setResidueWeight(new BigDecimal(200));
//        orderFeign.updateOrderInfoResidueWeight(param);


//        Message message = MessageBuilder.withBody("PT2023091900049".getBytes()).build();
//        message.getMessageProperties().setExpiration("10000");
//        rabbitTemplate.send(
//                RabbitKeyConstants.ORDER_GOODS_ON_EXCHANGE, RabbitKeyConstants.ORDER_GOODS_ON_ROUTE_KEY, message
//        );
    }
}
