package com.clx.performance.service.impl.vehiclewarn;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.dao.vehiclewarn.VehicleWarnConfigDao;
import com.clx.performance.dao.vehiclewarn.VehicleWarnInfoDao;
import com.clx.performance.dao.vehiclewarn.VehicleWarnRangeDao;
import com.clx.performance.enums.ResultEnum;
import com.clx.performance.enums.vehiclewarn.VehicleWarnRangEnum;
import com.clx.performance.model.vehiclewarn.VehicleWarnConfig;
import com.clx.performance.model.vehiclewarn.VehicleWarnInfo;
import com.clx.performance.model.vehiclewarn.VehicleWarnRang;
import com.clx.performance.param.pc.vehiclewarn.PageVehicleWarnRangeParam;
import com.clx.performance.param.pc.vehiclewarn.VehicleWarnRangeResumeUpdateParam;
import com.clx.performance.param.pc.vehiclewarn.VehicleWarnRangeSuspendUpdateParam;
import com.clx.performance.service.vehiclewarn.VehicleWarnRangeService;
import com.clx.performance.struct.vehiclewarn.VehicleWarnRangeStruct;
import com.clx.performance.utils.LocalDateTimeUtils;
import com.clx.performance.vo.pc.vehiclewarn.VehicleWarnRangDTO;
import com.msl.user.data.UserSessionData;
import com.msl.user.utils.TokenUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;

@Slf4j
@Service
public class VehicleWarnRangeServiceImpl implements VehicleWarnRangeService {
    @Autowired
    private VehicleWarnRangeDao vehicleWarnRangeDao;
    @Autowired
    private VehicleWarnRangeStruct vehicleWarnRangeStruct;
    @Autowired
    private VehicleWarnInfoDao vehicleWarnInfoDao;
    @Autowired
    private VehicleWarnConfigDao vehicleWarnConfigDao;

    @Override
    public void updateSuspend(VehicleWarnRangeSuspendUpdateParam param) {
        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();
        LocalDateTime endTime = LocalDateTimeUtils.parseTime(param.getWarnEndTime());

        VehicleWarnRang vehicleWarnRangOld = vehicleWarnRangeDao
                .findById(param.getId()).orElseThrow(ResultEnum.DATA_NOT_FIND);

        VehicleWarnConfig vehicleWarnConfig = vehicleWarnConfigDao
                .findById(vehicleWarnRangOld.getWarnConfigId()).orElseThrow(ResultEnum.DATA_NOT_FIND);

        VehicleWarnInfo vehicleWarnInfo = new VehicleWarnInfo();
        vehicleWarnInfo.setWarnConfigId(vehicleWarnRangOld.getWarnConfigId());
        vehicleWarnInfo.setOrderGoodsNo(vehicleWarnRangOld.getOrderGoodsNo());
        vehicleWarnInfo.setChildNo(vehicleWarnRangOld.getChildNo());
        vehicleWarnInfo.setSuspendTime(endTime);
        vehicleWarnInfoDao.updateSuspendTime(vehicleWarnInfo, vehicleWarnRangOld.getWarnRang());

        VehicleWarnRang vehicleWarnRang = new VehicleWarnRang();
        vehicleWarnRang.setWarnConfigId(vehicleWarnConfig.getId());
        vehicleWarnRang.setWarnName(vehicleWarnConfig.getWarnName());
        vehicleWarnRang.setWarnRang(vehicleWarnRangOld.getWarnRang());
        vehicleWarnRang.setOrderGoodsNo(vehicleWarnRangOld.getOrderGoodsNo());
        vehicleWarnRang.setChildNo(vehicleWarnRangOld.getChildNo());
        vehicleWarnRang.setWarnEndTime(endTime);
        vehicleWarnRang.setStatus(VehicleWarnRangEnum.Status.ENABLE.getCode());
        vehicleWarnRang.setCreateBy(loginUserInfo.getUserName());

        // 禁用旧数据
        vehicleWarnRangeDao.updateDisable(vehicleWarnRang);
        // 新增新数据
        vehicleWarnRangeDao.saveEntity(vehicleWarnRang);
    }

    @Override
    public void updateResume(VehicleWarnRangeResumeUpdateParam param) {
        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();
        LocalDateTime endTime = LocalDateTime.now().minusSeconds(1);

        VehicleWarnRang vehicleWarnRangOld = vehicleWarnRangeDao
                .findById(param.getId()).orElseThrow(ResultEnum.DATA_NOT_FIND);

        VehicleWarnConfig vehicleWarnConfig = vehicleWarnConfigDao
                .findById(vehicleWarnRangOld.getWarnConfigId()).orElseThrow(ResultEnum.DATA_NOT_FIND);

        VehicleWarnInfo vehicleWarnInfo = new VehicleWarnInfo();
        vehicleWarnInfo.setWarnConfigId(vehicleWarnRangOld.getWarnConfigId());
        vehicleWarnInfo.setOrderGoodsNo(vehicleWarnRangOld.getOrderGoodsNo());
        vehicleWarnInfo.setChildNo(vehicleWarnRangOld.getChildNo());
        vehicleWarnInfo.setSuspendTime(endTime);
        vehicleWarnInfoDao.updateSuspendTime(vehicleWarnInfo, vehicleWarnRangOld.getWarnRang());

        VehicleWarnRang vehicleWarnRang = new VehicleWarnRang();
        vehicleWarnRang.setWarnConfigId(vehicleWarnConfig.getId());
        vehicleWarnRang.setWarnName(vehicleWarnConfig.getWarnName());
        vehicleWarnRang.setWarnRang(vehicleWarnRangOld.getWarnRang());
        vehicleWarnRang.setOrderGoodsNo(vehicleWarnRangOld.getOrderGoodsNo());
        vehicleWarnRang.setChildNo(vehicleWarnRangOld.getChildNo());
        vehicleWarnRang.setWarnEndTime(endTime);
        vehicleWarnRang.setStatus(VehicleWarnRangEnum.Status.ENABLE.getCode());
        vehicleWarnRang.setCreateBy(loginUserInfo.getUserName());

        // 禁用旧数据
        vehicleWarnRangeDao.updateDisable(vehicleWarnRang);
        // 新增新数据
        vehicleWarnRangeDao.saveEntity(vehicleWarnRang);

    }

    @Override
    public VehicleWarnRangDTO getRange(Integer id) {
        return vehicleWarnRangeStruct.convert(vehicleWarnRangeDao.findById(id).orNull());
    }

    @Override
    public IPage<VehicleWarnRangDTO> pageRange(PageVehicleWarnRangeParam param) {
        Page<VehicleWarnRangDTO> page = vehicleWarnRangeStruct.convertPage(vehicleWarnRangeDao.pageByParam(param));

        return page;
    }
}
