package com.clx.performance.model.export;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

@Getter
@Setter
@Accessors(chain = true)
@TableName("export_field")
public class ExportField implements HasKey<Integer> {

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;


    @TableField("export_function_code")
    @ApiModelProperty("功能code")
    private String exportFunctionCode;

    @TableField("name")
    @ApiModelProperty("字段名称")
    private String name;

    @TableField("code")
    @ApiModelProperty("字段code,用于映射真实数据字段")
    private String code;

    @TableField("required")
    @ApiModelProperty("是否必填：1是，0否")
    private Integer required;

    @TableField("sort")
    @ApiModelProperty("排序字段")
    private Integer sort;

    @TableField("remark")
    @ApiModelProperty("字段描述")
    private String remark;

    @Override
    @KeyColumn("id")
    public Integer gainKey() {
        return this.id;
    }
}
