package com.clx.performance.param.pc.vehiclewarn;

import com.msl.common.base.PageParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

@Getter
@Setter
@NoArgsConstructor
public class PageVehicleWarnInfoParam extends PageParam {

    @ApiModelProperty(value = "预警名称", example = "超时")
    private String warnName;
    @ApiModelProperty(value = "预警类型: 1到达货源地延误 2前往货源地超时 3到达目的地延误 4前往目的地超时 5停留超时 6敏感区停留 7装车超时 8卸车超时 9运单延误", example = "1")
    private Integer warnType;
    @ApiModelProperty(value = "预警级别", example = "1")
    private Integer warnLevel;

    @ApiModelProperty(value = "货单编号", example = "1000")
    private String orderGoodsNo;
    @ApiModelProperty(value = "运单编号", example = "1000")
    private String childNo;
    @ApiModelProperty(value = "处理状态：1待处理 2已处理 3暂停预警", example = "1")
    private Integer status;

    @ApiModelProperty(value = "发货地址", example = "北京")
    private String sendAddress;
    @ApiModelProperty(value = "收货地址", example = "山西")
    private String receiveAddress;

    @ApiModelProperty(value = "开始时间", example = "")
    private String beginTime;
    @ApiModelProperty(value = "结束时间", example = "")
    private String endTime;

}
