package com.clx.performance.service.impl.linewarn;

import com.clx.order.vo.feign.FeignAddressVO;
import com.clx.performance.dao.linewarn.LineWarnConfigDao;
import com.clx.performance.dao.linewarn.LineWarnInfoDao;
import com.clx.performance.dto.linewarn.LineWarnCommonInfoDTO;
import com.clx.performance.enums.linewarn.LineWarnConfigEnum;
import com.clx.performance.enums.linewarn.LineWarnInfoEnum;
import com.clx.performance.extranal.order.InternalReportService;
import com.clx.performance.extranal.user.AddressService;
import com.clx.performance.model.OrderGoods;
import com.clx.performance.model.linewarn.LineWarnConfig;
import com.clx.performance.model.linewarn.LineWarnInfo;
import com.clx.performance.service.linewarn.LineWarnCommonService;
import com.clx.performance.service.linewarn.LineWarnWeatherWarnService;
import com.clx.performance.utils.gd.GdUtils;
import com.msl.common.base.Optional;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Objects;

@Slf4j
@Service
public class LineWarnWeatherWarnServiceImpl implements LineWarnWeatherWarnService {
    @Autowired
    private LineWarnConfigDao lineWarnConfigDao;

    @Autowired
    private InternalReportService internalReportService;
    @Autowired
    private LineWarnCommonService lineWarnCommonService;
    @Autowired
    private LineWarnInfoDao lineWarnInfoDao;
    @Autowired
    private GdUtils gdUtils;
    @Autowired
    private AddressService addressService;

    @Override
    public void weatherWarn(OrderGoods orderGoods, LineWarnCommonInfoDTO lineWarnCommonInfo) {

        List<LineWarnConfig> lineWarnConfigList = lineWarnConfigDao
                .listByWarnType(LineWarnConfigEnum.WarnType.WEATHER.getCode());
        if (lineWarnConfigList.isEmpty()) {return;}

        for (LineWarnConfig item : lineWarnConfigList) {
            doWeather(orderGoods, item);
        }

    }

    private void doWeather(OrderGoods orderGoods, LineWarnConfig lineWarnConfig){
        LineWarnInfo lineWarnInfo = lineWarnInfoDao
                .findByOrderGoodsNoAndWarnConfigId(orderGoods.getOrderGoodsNo(), lineWarnConfig.getId()).orNull();
        if (lineWarnInfo != null
                && Objects.equals(lineWarnInfo.getStatus(), LineWarnInfoEnum.Status.RESOLVE.getCode())){
            return;
        }

        Optional<FeignAddressVO> addressOptional = addressService
                .getSendAndReceiveAddress(orderGoods.getSendAddressId(), orderGoods.getReceiveAddressId());
        if (addressOptional.isEmpty()) {return;}
        FeignAddressVO feignAddressVO = addressOptional.get();

        if (feignAddressVO.getSendAddress()!=null
                && StringUtils.isNotBlank(feignAddressVO.getSendAddress().getCityCode())){
            String weather = gdUtils.getWeather(feignAddressVO.getSendAddress().getCityCode());
            if (weatherCheck(weather)){
                // 更新
                lineWarnCommonService.lineWarnInfoUpdate(orderGoods, lineWarnInfo, lineWarnConfig, weather);
            }
        }
        if (feignAddressVO.getReceiveAddress()!=null
                && StringUtils.isNotBlank(feignAddressVO.getReceiveAddress().getCityCode())){
            String weather = gdUtils.getWeather(feignAddressVO.getReceiveAddress().getCityCode());
            if (weatherCheck(weather)){
                // 更新
                lineWarnCommonService.lineWarnInfoUpdate(orderGoods, lineWarnInfo, lineWarnConfig, weather);
            }
        }

    }

    /**
     * 天气验证
     */
    private boolean weatherCheck(String weather){
        if (weather.contains("雨")
            || weather.contains("雪")
            || weather.contains("沙尘暴")
            || weather.contains("强沙尘暴")
            || weather.contains("大雾")
            || weather.contains("浓雾")
            || weather.contains("强浓雾")
            || weather.contains("特强浓雾")
            || weather.contains("雾")
            || weather.contains("中度霾")
            || weather.contains("重度霾")
            || weather.contains("严重霾")
        ){
            return true;
        }
        return false;
    }
}
