package com.clx.performance.dao.settle;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.mapper.settle.SettlementOwnerMapper;
import com.clx.performance.model.settle.SettlementOwner;
import com.clx.performance.param.pc.owner.PageCarrierSettlementOwnerParam;
import com.msl.common.base.Optional;
import com.clx.performance.param.pc.owner.PageOwnerSettlementParam;
import com.msl.common.dao.BaseDao;
import org.apache.ibatis.annotations.Param;

import java.time.LocalDateTime;
import java.util.List;


public interface SettlementOwnerDao extends BaseDao<SettlementOwnerMapper, SettlementOwner, Integer> {
    boolean updateSettlementPeriodMonth(SettlementOwner item);

    boolean updateLock(SettlementOwner item);

    List<SettlementOwner> getMergeSettlementNos(@Param("settlementNo")String settlementNo);

    boolean updateStatusBySettlementNo(@Param("settlementNo")String settlementNo, @Param("status")Integer status);

    boolean updateInvoiceStatusBySettlementNo(@Param("settlementNo")String settlementNo, @Param("status")Integer status);


    boolean updateInvoiceStatusById(@Param("id")Integer id, @Param("invoiceStatus")Integer invoiceStatus);

    boolean updatePayment(SettlementOwner settlementOwner);

    IPage<SettlementOwner> pageCarrierSettlementOwner(PageCarrierSettlementOwnerParam param);

    Optional<SettlementOwner> selectBySettlementNo(@Param("settlementNo")String settlementNo);

    IPage<SettlementOwner> pageSettlementOwner(Long userNo,PageOwnerSettlementParam param);

    Optional<SettlementOwner> selectUnlockOfSettlementPeriodMonth(@Param("orderNo")String orderNo,
                                                                  @Param("settlementPeriodTime") LocalDateTime settlementPeriodTime,
                                                                  @Param("invoiceType")Integer invoiceType);
    Optional<SettlementOwner> selectUnlockOfSettlementPeriodImmediate(@Param("orderNo")String orderNo,
                                                                      @Param("invoiceType")Integer invoiceType);
    List<SettlementOwner> listToBeLockOfSettlementPeriodMonth(@Param("settlementPeriodTime") LocalDateTime settlementPeriodTime);

    boolean uploadInvoiceImg(@Param("settlementNo")String settlementNo, @Param("invoiceImg")String invoiceImg);

    boolean saveExpress(@Param("settlementNo")String settlementNo, @Param("expressCompany")String expressCompany, @Param("expressNo")String expressNo);

    boolean savePayee(@Param("settlementNo")String settlementNo,
                        @Param("payee")String payee,
                        @Param("payeeBankName")String payeeBankName,
                        @Param("payeeBankCardNo")String payeeBankCardNo,
                        @Param("paymentImg")String paymentImg,
                        @Param("paymentBankCardNo")String paymentBankCardNo,
                        @Param("paymentBankName")String paymentBankName,
                        @Param("paymentAmount")String paymentAmount);


    boolean updateStatusByOrderNo(@Param("orderNo")String orderNo,
                                  @Param("settlementPeriodType")Integer settlementPeriodType,
                                  @Param("fromStatus")Integer fromStatus,
                                  @Param("toStatus")Integer toStatus);

    void updateSettlementMerge(@Param("settlementNo")String settlementNo,
            @Param("settlementNos")List<String> settlementNos,
            @Param("mergedBy") String mergedBy,
            @Param("mergeTime") LocalDateTime mergeTime);
}
