package com.clx.performance.dao.impl.linewarn;

import com.clx.performance.dao.linewarn.LineWarnRangeDao;
import com.clx.performance.enums.linewarn.LineWarnRangEnum;
import com.clx.performance.mapper.linewarn.LineWarnRangMapper;
import com.clx.performance.model.linewarn.LineWarnRang;
import com.msl.common.dao.impl.BaseDaoImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Repository;

import java.util.List;

@Repository
public class LineWarnRangeDaoImpl extends BaseDaoImpl<LineWarnRangMapper, LineWarnRang, Integer> implements LineWarnRangeDao {


    @Override
    public List<LineWarnRang> ListByWarnConfigId(Integer warnConfigId) {
        return list(lQrWrapper()
                        .eq(LineWarnRang::getWarnConfigId, warnConfigId)
                        .eq(LineWarnRang::getStatus, LineWarnRangEnum.Status.ENABLE.getCode())
                        .orderByDesc(LineWarnRang::getId)
                );
    }

    @Override
    public boolean updateDisable(LineWarnRang item) {
        return update(lUdWrapper()
                .eq(LineWarnRang::getWarnConfigId, item.getWarnConfigId())
                .eq(StringUtils.isNotBlank(item.getOrderGoodsNo()), LineWarnRang::getOrderGoodsNo, item.getOrderGoodsNo())
                .set(LineWarnRang::getStatus, LineWarnRangEnum.Status.DISABLE.getCode())
        );
    }
}
