package com.clx.performance.vo.pc.trace;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.math.BigDecimal;

@Getter
@Setter
@NoArgsConstructor
public class DriverTraceVO {

    @ApiModelProperty(value = "经度")
    private BigDecimal longitude;
    @ApiModelProperty(value = "纬度")
    private BigDecimal latitude;
    @ApiModelProperty(value = "GPS 时间")
    private String gpsTime;
    @ApiModelProperty(value = "速度")
    private BigDecimal speed;
    @ApiModelProperty(value = "停留时长（min）", example = "12.3")
    private BigDecimal stayTime=BigDecimal.ZERO;
    @ApiModelProperty(value = "停留结束时间")
    private String stayEndTime;
    @ApiModelProperty(value = "车辆状态：1空车 2重车", example = "1")
    private Integer truckStatus;
}
