package com.clx.performance.vo.pc.linewarn;

import com.clx.performance.enums.OrderGoodsStatusEnum;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.math.BigDecimal;
import java.util.List;

@Getter
@Setter
@NoArgsConstructor
public class LineWarnTraceVO {

    @ApiModelProperty(value = "货单编号", example = "10000")
    private String orderGoodsNo;

    @ApiModelProperty(value = "发货地址id", example = "1")
    private Integer sendAddressId;
    @ApiModelProperty(value = "发货地址", example = "北京")
    private String sendAddress;
    @ApiModelProperty(value = "收货地址id", example = "2")
    private Integer receiveAddressId;
    @ApiModelProperty(value = "收货地址", example = "山西")
    private String receiveAddress;

    @ApiModelProperty("发货地址经度")
    private BigDecimal sendLongitude;
    @ApiModelProperty("发货地址纬度")
    private BigDecimal sendLatitude;
    @ApiModelProperty("收货地址经度")
    private BigDecimal receiveLongitude;
    @ApiModelProperty("收货地址纬度")
    private BigDecimal receiveLatitude;

    @ApiModelProperty("货单状态")
    private Integer orderGoodsStatus;
    @ApiModelProperty("货单状态")
    private String orderGoodsStatusMsg;
    public String getOrderGoodsStatusMsg() {
        return OrderGoodsStatusEnum.Status.getMsgByCode(orderGoodsStatus);
    }
    @ApiModelProperty("提取吨数")
    private BigDecimal extractWeight;
    @ApiModelProperty("装车吨数")
    private BigDecimal loadWeight;
    @ApiModelProperty("卸车吨数")
    private BigDecimal unloadWeight;

    @ApiModelProperty("车辆列表")
    private List<LineWarnTruckTraceInfoVO> truckList;

    @ApiModelProperty("推荐线路")
    private LineWarnRouteVO route;

}
