package com.clx.performance.controller.app;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.clx.performance.param.app.collect.CollectTruckRefuelSaveParam;
import com.clx.performance.param.app.collect.PageCollectTruckRefuelParam;
import com.clx.performance.service.collect.CollectTruckRefuelService;
import com.clx.performance.vo.pc.collect.CollectTruckRefuelVO;
import com.msl.common.base.PageData;
import com.msl.common.convertor.aspect.UnitCovert;
import com.msl.common.result.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

@Slf4j
@RestController
@RequestMapping(value="/app/driver/collect/refuel")
@Validated
@Api(tags = "APP-油表上报")
@AllArgsConstructor
public class AppDriverCollectTruckRefuelController {

    private final CollectTruckRefuelService collectTruckRefuelService;

    @ApiOperation(value = "上报油表", notes = "<br>By:艾庆国")
    @PostMapping("/saveRefuelReport")
    public Result<Void> saveRefuelReport(@RequestBody @Validated CollectTruckRefuelSaveParam param) {
        collectTruckRefuelService.saveRefuelReport(param);

        return Result.ok();
    }

    @ApiOperation(value = "查询油表上报详情", notes = "<br>By:艾庆国")
    @GetMapping("/getReportInfo")
    public Result<CollectTruckRefuelVO> getReportInfo(Integer id) {

        return Result.ok(collectTruckRefuelService.getReportInfo(id));
    }

    @ApiOperation(value = "分页查询油表上报列表",notes = "<br>By:艾庆国")
    @PostMapping("/pageRefuelReport")
    @UnitCovert(param = false)
    public Result<PageData<CollectTruckRefuelVO>> pageRefuelReport(@RequestBody @Validated PageCollectTruckRefuelParam param) {
        IPage<CollectTruckRefuelVO> page = collectTruckRefuelService.pageRefuelReport(param);
        return Result.page(page.getRecords(), page.getTotal(), page.getPages());
    }

}
