package com.clx.performance.config;

import com.clx.performance.constant.RabbitKeyBrokerConstants;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.Queue;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.HashMap;
import java.util.Map;

/**
 * @Author: aiqingguo
 * @Description: 无车承运 MQ
 * @Date: 2023-10-12 16:27:30
 * @Version: 1.0
 */
@Configuration
public class RabbitBrokerConfig {

    @Bean
    public DirectExchange brokerDefaultExchange() {
        return new DirectExchange(RabbitKeyBrokerConstants.DEFAULT_EXCHANGE);
    }

    @Bean
    public Queue brokerDefaultDelayQueue() {
        Map<String, Object> params = new HashMap<>(8);
        params.put("x-message-ttl", 15 * 60 * 1000);
        params.put("x-max-length", 5000000);
        params.put("x-dead-letter-exchange", RabbitKeyBrokerConstants.DEFAULT_EXCHANGE);
        params.put("x-dead-letter-routing-key", RabbitKeyBrokerConstants.DEFAULT_DEAD_ROUTING_KEY);
        return new Queue(RabbitKeyBrokerConstants.DEFAULT_DELAY_QUEUE, true, false, false, params);
    }
    @Bean
    public Binding brokerDefaultDelayQueueBinding() {
        return BindingBuilder.bind(brokerDefaultDelayQueue()).to(brokerDefaultExchange())
                .with(RabbitKeyBrokerConstants.DEFAULT_DELAY_ROUTING_KEY);
    }

    @Bean
    public Queue brokerDefaultDeadQueue() {
        return new Queue(RabbitKeyBrokerConstants.DEFAULT_DEAD_QUEUE);
    }
    @Bean
    public Binding brokerDefaultDeadQueueBinding() {
        return BindingBuilder.bind(brokerDefaultDeadQueue()).to(brokerDefaultExchange())
                .with(RabbitKeyBrokerConstants.DEFAULT_DEAD_ROUTING_KEY);
    }


    /**
     * 运单同步
     */
    @Bean
    public Queue brokerOrderChildSyncQueue() {
        return new Queue(RabbitKeyBrokerConstants.ORDER_CHILD_SYNC_QUEUE);
    }
    @Bean
    public Binding brokerOrderChildSyncQueueBinding() {
        return BindingBuilder.bind(brokerOrderChildSyncQueue()).to(brokerDefaultExchange())
                .with(RabbitKeyBrokerConstants.ORDER_CHILD_SYNC_ROUTING_KEY);
    }

    /**
     * 运单更新
     */
    @Bean
    public Queue brokerOrderChildUpdateQueue() {
        return new Queue(RabbitKeyBrokerConstants.ORDER_CHILD_UPDATE_QUEUE);
    }
    @Bean
    public Binding brokerOrderChildUpdateQueueBinding() {
        return BindingBuilder.bind(brokerOrderChildUpdateQueue()).to(brokerDefaultExchange())
                .with(RabbitKeyBrokerConstants.ORDER_CHILD_UPDATE_ROUTING_KEY);
    }

}
