package com.clx.performance.sqlProvider;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.order.params.PageOrderGoodsListParam;
import com.clx.order.vo.feign.FeignPageOrderVO;
import com.clx.performance.enums.OrderGoodsStatusEnum;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.jdbc.SQL;

import java.util.Objects;

public class OrderGoodsSqlProvider {

    public String getMaxOrderGoodsId(String type) {
        return "SELECT s.order_goods_no FROM  `order_goods` s WHERE s. id = ( SELECT max(id) FROM order_goods where order_goods_type = '" + type + "')";

    }

    public String pageOrderGoodsList(@Param("page") Page<FeignPageOrderVO> page, @Param("param") PageOrderGoodsListParam param) {
        String sql = new SQL() {{
            SELECT("a.id, a.order_no," +
                    " a.order_goods_no, a.order_goods_status, a.extract_weight, " +
                    " a.residue_transport_weight,a.already_transport_weight, a.send_address_id, a.send_address_shorter,a.send_longitude," +
                    " a.send_latitude,a.receive_address_id, a.receive_address_shorter,a.receive_longitude,a.receive_latitude," +
                    "a.goods_id, a.goods_name, a.pending_order_way," +
                    " date_format(a.directional_expire_time, '%Y-%m-%d %H:%i:%s') as directional_expire_time ," +
                    " date_format(a.last_arrive_send_time, '%Y-%m-%d %H:%i:%s') as last_arrive_send_time ," +
                    " date_format(a.pending_order_time, '%Y-%m-%d %H:%i:%s') as pending_order_time," +
                    " date_format(a.create_time, '%Y-%m-%d %H:%i:%s') as create_time," +
                    " date_format(a.modified_time, '%Y-%m-%d %H:%i:%s') as modified_time," +
                    "a.extract_way,a.need_truck_num,a.senior_logistics_manager_id,a.senior_logistics_manager_name,a.pending_order_freight," +
                    "a.user_no,a.user_name");
            FROM("order_goods a");

            if (StringUtils.isNotBlank(param.getBeginTime()) && StringUtils.isNotBlank(param.getEndTime())) {
                WHERE("a.create_time >= #{param.beginTime}");
                WHERE("a.create_time <= #{param.endTime}");
            }

            if (Objects.nonNull(param.getTruckDemand())) {
                if (1 == param.getTruckDemand()) {
                    WHERE("a.truck_demand = #{param.truckDemand}");
                } else if (2 == param.getTruckDemand()) {
                    WHERE("a.truck_demand = #{param.truckDemand}");
                } else if (3 == param.getTruckDemand()) {
                    WHERE("a.truck_demand = #{param.truckDemand}");
                }
            }
            if (Objects.nonNull(param.getOrderGoodsStatus())) {
                if (OrderGoodsStatusEnum.Status.CREATED.getCode().equals(param.getOrderGoodsStatus())) {
                    WHERE("a.order_goods_status = #{param.orderGoodsStatus}");
                } else if (OrderGoodsStatusEnum.Status.PAYING.getCode().equals(param.getOrderGoodsStatus())) {
                    WHERE("a.order_goods_status = #{param.orderGoodsStatus}");
                } else if (OrderGoodsStatusEnum.Status.GO_TO_SEND.getCode().equals(param.getOrderGoodsStatus())) {
                    WHERE("a.order_goods_status = #{param.orderGoodsStatus}");
                } else if (OrderGoodsStatusEnum.Status.ARRIVE_SEND.getCode().equals(param.getOrderGoodsStatus())) {
                    WHERE("a.order_goods_status = #{param.orderGoodsStatus}");
                } else if (OrderGoodsStatusEnum.Status.CANCEL.getCode().equals(param.getOrderGoodsStatus())) {
                    WHERE("a.order_goods_status = #{param.orderGoodsStatus}");
                }
            }

            if (StringUtils.isNotBlank(param.getOrderNo())) {
                WHERE("a.order_no = #{param.orderNo}");
            }
            if (StringUtils.isNotBlank(param.getOrderGoodsNo())) {
                WHERE("a.order_goods_no = #{param.orderGoodsNo}");
            }
            ORDER_BY("a.create_time desc");
        }}.toString();
        return sql;
    }
}
