package com.clx.performance.sqlProvider;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.param.app.PageOrderChildOfDriverParam;
import com.clx.performance.param.pc.PagePoundAuditParam;
import com.clx.performance.vo.app.OrderChildVO;
import com.clx.performance.vo.pc.PageOrderChildPoundAuditVO;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.jdbc.SQL;

import java.util.Objects;

public class OrderChildSqlProvider {

    public String pageOrderChildOfDriver(@Param("page") Page<OrderChildVO> page, @Param("param") PageOrderChildOfDriverParam param) {
        return new SQL(){{
            SELECT("child_no,goods_name,freight_price," +
                    "send_address,receive_address," +
                    "driver_name,driver_mobile," +
                    "truck_no," +
                    "weight," +
                    "cancel_remark," +
                    "pound_status,status," +
                    "date_format(load_deadline, '%Y-%m-%d %H:%i:%s') as loadDeadline," +
                    "date_format(unload_time, '%Y-%m-%d %H:%i:%s') as unloadTime "
            );
            FROM("order_child ");
            WHERE("(user_no = #{param.userNo} or driver_user_no = #{param.userNo}) ");
            if (StringUtils.isNotBlank(param.getContent())) {WHERE("(" +
                    "    owner_name like CONCAT(#{param.content},'%') " +
                    " or truck_no like CONCAT(#{param.content},'%') " +
                    " or driver_name like CONCAT(#{param.content},'%') " +
                    " or send_address like CONCAT(#{param.content},'%') " +
                    " or receive_address like CONCAT(#{param.content},'%') " +
                    ")");}

            if (Objects.nonNull(param.getStatus())) {WHERE("status = #{param.status}");}

            ORDER_BY("create_time desc");
        }}.toString();
    }

    public String pagePoundAuditList(@Param("page") Page<PageOrderChildPoundAuditVO> page, @Param("param") PagePoundAuditParam param) {
        return new SQL(){{
            SELECT("child_no,status,goods_name,send_address,receive_address,driver_name,driver_mobile,load_net,unload_net," +
                    "pound_status,date_format(pay_time, '%Y-%m-%d %H:%i:%s') as payTime," +
                    "date_format(load_time, '%Y-%m-%d %H:%i:%s') as loadTime," +
                    "date_format(unload_time, '%Y-%m-%d %H:%i:%s') as unloadTime ");
            FROM("order_child ");
            WHERE("pound_status >0");
            if (StringUtils.isNotBlank(param.getBeginTime())) {WHERE("pay_time >= #{param.beginTime}");}
            if (StringUtils.isNotBlank(param.getEndTime())) {WHERE("pay_time <= #{param.endTime}");}

            if (StringUtils.isNotBlank(param.getChildNo())) {WHERE("child_no = #{param.childNo}");}
            if (StringUtils.isNotBlank(param.getDriverName())) {WHERE("driver_name= #{param.driverName}");}
            if (StringUtils.isNotBlank(param.getDriverMobile())) {WHERE("driver_mobile = #{param.driverMobile}");}

            if (StringUtils.isNotBlank(param.getSendAddress())) {WHERE("send_address = #{param.sendAddress}");}
            if (StringUtils.isNotBlank(param.getReceiveAddress())) {WHERE("receive_address= #{param.receiveAddress}");}
            if (Objects.nonNull(param.getStatus())) {WHERE("pound_status = #{param.status}");}

            ORDER_BY("unload_time,pound_status");
        }}.toString();
    }


}
