package com.clx.performance.service.impl;


import com.clx.performance.dao.OrderChildDao;
import com.clx.performance.dao.OrderChildImageDao;
import com.clx.performance.dao.OrderChildPoundAuditDao;
import com.clx.performance.dao.OrderChildPoundLogDao;
import com.clx.performance.enums.OrderChildLogEnum;
import com.clx.performance.enums.OrderChildPoundAuditEnum;
import com.clx.performance.enums.PerformanceResultEnum;
import com.clx.performance.model.*;
import com.clx.performance.param.pc.PoundAuditParam;
import com.clx.performance.service.OrderChildLogService;
import com.clx.performance.service.OrderChildPoundAuditService;
import com.clx.performance.vo.pc.OrderChildPoundAuditDetailVO;
import com.msl.user.data.UserSessionData;
import com.msl.user.utils.TokenUtil;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * @author liruixin
 * Date 2023-09-19
 * Time 13:25
 */
@Slf4j
@Service
@AllArgsConstructor
public class OrderChildPoundAuditServiceImpl  implements OrderChildPoundAuditService {

    private final OrderChildImageDao orderChildImageDao;

    private final OrderChildPoundAuditDao orderChildPoundAuditDao;

    private final OrderChildPoundLogDao orderChildPoundLogDao;

    private final OrderChildDao orderChildDao;

    private final OrderChildLogService orderChildLogService;


    @Override
    public OrderChildPoundAuditDetailVO getPoundAuditDetail(String childNo) {
        OrderChildPoundAudit poundAuditDetail = orderChildPoundAuditDao.getPoundAuditDetail(childNo).orElseThrow(PerformanceResultEnum.DATA_NOT_FIND);
        List<OrderChildImage> loadImages = orderChildImageDao.getImages(childNo, OrderChildImage.Type.LOAD.getCode()).orElseThrow(PerformanceResultEnum.DATA_NOT_FIND);
        List<OrderChildImage> unloadImages = orderChildImageDao.getImages(childNo, OrderChildImage.Type.UNLOAD.getCode()).orElseThrow(PerformanceResultEnum.DATA_NOT_FIND);
        OrderChildPoundAuditDetailVO vo = new OrderChildPoundAuditDetailVO();
        vo.setChildNo(childNo);
        vo.setLoadImages(loadImages.stream().map(OrderChildImage::getImage).collect(Collectors.toList()));
        vo.setUnloadImages(unloadImages.stream().map(OrderChildImage::getImage).collect(Collectors.toList()));
        vo.setLoadNet(poundAuditDetail.getLoadNet());
        vo.setUnloadNet(poundAuditDetail.getUnloadNet());
        vo.setStatus(poundAuditDetail.getStatus());
        vo.setRemark(poundAuditDetail.getRemark());
        vo.setRejectType(poundAuditDetail.getRejectType());
        return vo;
    }


    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updatePoundAudit(PoundAuditParam param) {

        OrderChild orderChild = orderChildDao.getByChildNo(param.getChildNo()).orElseThrow(PerformanceResultEnum.DATA_NOT_FIND);

        OrderChildPoundAudit poundAuditDetail = orderChildPoundAuditDao.getPoundAuditDetail(param.getChildNo()).orElseThrow(PerformanceResultEnum.DATA_NOT_FIND);
        poundAuditDetail.setStatus(param.getStatus());
        poundAuditDetail.setRejectType(param.getRejectType());
        poundAuditDetail.setRemark(param.getRemark());
        poundAuditDetail.setId(null);

        Integer type = OrderChildLogEnum.Type.POUND_AUDIT.getCode();
        if(Objects.equals(param.getStatus(), OrderChildPoundAuditEnum.Status.REJECT.getCode())){
            poundAuditDetail.setLoadNet(orderChild.getLoadNet());
            poundAuditDetail.setUnloadNet(orderChild.getUnloadNet());
            type = OrderChildLogEnum.Type.POUND_AUDIT_REJECT.getCode();
        }else{
            if(Objects.nonNull(param.getLoadNet())){
                poundAuditDetail.setLoadNet(param.getLoadNet());
            }else{
                poundAuditDetail.setLoadNet(orderChild.getLoadNet());
            }

            if(Objects.nonNull(param.getUnloadNet())){
                poundAuditDetail.setUnloadNet(param.getUnloadNet());
            }else{
                poundAuditDetail.setUnloadNet(orderChild.getUnloadNet());
            }
        }


        orderChildPoundAuditDao.saveEntity(poundAuditDetail);

        UserSessionData loginUserInfo = TokenUtil.getLoginUserInfo();
        OrderChildPoundLog poundLog = OrderChildPoundLog.builder().childNo(param.getChildNo()).status(param.getStatus()).createType(OrderChildLogEnum.CreateType.PLATFORM.getCode())
                .remark(OrderChildPoundAuditEnum.Status.getByCode(param.getStatus()).get().getMsg()).createBy(loginUserInfo.getUserNo()).createName(loginUserInfo.getUserName()).build();

        orderChildPoundLogDao.saveEntity(poundLog);

        if(Objects.nonNull(param.getLoadNet())){
            orderChild.setLoadNet(param.getLoadNet());
        }
        if(Objects.nonNull(param.getUnloadNet())){
            orderChild.setUnloadNet(param.getUnloadNet());
        }
        orderChild.setPoundStatus(param.getStatus());
        orderChildDao.updatePoundAuditStatus(orderChild);

        orderChildLogService.saveOrderChildLog(param.getChildNo(),type,OrderChildLogEnum.Type.getByCode(type).get().getMsg(),
                OrderChildLogEnum.CreateType.PLATFORM.getCode(), loginUserInfo.getUserNo(),loginUserInfo.getUserName());

    }
}
