package com.clx.performance.model;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.msl.common.config.KeyColumn;
import com.msl.common.model.HasKey;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * 货单定向绑定车辆表
 */
@Getter
@Setter
@Accessors(chain = true)
@TableName("order_goods_truck_bind")
public class OrderGoodsTruckBind implements HasKey<Integer> {

    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @TableField("truck_no")
    @ApiModelProperty("车牌号")
    private String truckNo;

    @TableField("order_no")
    @ApiModelProperty("订单编号")
    private String driverUserNo;

    @TableField("order_goods_no")
    @ApiModelProperty("货单编号")
    private String orderGoodsNo;

    @TableField("create_time")
    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;

    @TableField("modified_time")
    @ApiModelProperty("修改时间")
    private LocalDateTime modifiedTime;


    @Override
    @KeyColumn("id")
    public Integer gainKey() {
    return this.id;
    }
}
