package com.clx.performance.extranal.user.impl;

import com.clx.performance.extranal.user.DriverService;
import com.clx.user.feign.DriverFeign;
import com.clx.user.vo.feign.DriverTruckInfoFeignVo;
import com.msl.common.base.Optional;
import com.msl.common.result.Result;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

@Slf4j
@Service
@AllArgsConstructor
public class DriverServiceImpl implements DriverService {

    private final DriverFeign driverFeign;

    @Override
    public Optional<DriverTruckInfoFeignVo> getUserDetailInfo(Long driverUserNo, Integer truckId) {
        Optional<DriverTruckInfoFeignVo> map = Optional.ofNullable(driverFeign.getDriverTruckInfo(driverUserNo, truckId))
                .filter(Result::succeed)
                .map(Result::getData);

        return map;

    }
}
