package com.clx.performance.dao.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.QueryChainWrapper;
import com.clx.performance.dao.OrderGoodsDriverTruckDao;
import com.msl.common.dao.BaseDao;
import com.msl.common.dao.impl.BaseDaoImpl;
import com.clx.performance.mapper.OrderGoodsDriverTruckMapper;
import com.clx.performance.model.OrderGoodsDriverTruck;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @author kavin
 * Date 2023-09-17
 * Time 16:45
 */
@Repository
public class OrderGoodsDriverTruckDaoImpl extends BaseDaoImpl<OrderGoodsDriverTruckMapper, OrderGoodsDriverTruck, Integer> implements OrderGoodsDriverTruckDao {
    @Override
    public List<Integer> getTrucksByOrderGoodsNo(String orderGoodsNo) {
        return baseMapper.getTrucksByOrderGoodsNo(orderGoodsNo);
    }

    @Override
    public void deleteByTruckNoAndDriverUserNo(String truckNo, String driverUserNo) {
        baseMapper.delete(new QueryWrapper<OrderGoodsDriverTruck>().lambda()
                .eq(OrderGoodsDriverTruck::getTruckNo,truckNo)
                .eq(OrderGoodsDriverTruck::getDriverUserNo, Long.valueOf(driverUserNo))
        );
    }
}
