package com.clx.performance.dao.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.order.params.PageOrderGoodsListParam;
import com.clx.performance.dao.OrderGoodsDao;
import com.clx.performance.mapper.OrderGoodsMapper;
import com.clx.performance.model.OrderGoods;
import com.clx.performance.vo.pc.OrderGoodsVO;
import com.msl.common.base.Optional;
import com.msl.common.dao.impl.BaseDaoImpl;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.math.BigDecimal;

/**
 * @author kavin
 * Date 2023-09-17
 * Time 16:45
 */
@Repository
public class OrderGoodsDaoImpl extends BaseDaoImpl<OrderGoodsMapper, OrderGoods, Integer> implements OrderGoodsDao {

    @Override
    public boolean updateWeight(@Param("orderId")Integer orderId, @Param("weight") BigDecimal weight) {
         return baseMapper.updateWeight(orderId, weight)>0;
    }

    @Override
    public Long getMaxOrderGoodsId(String type) {
        return baseMapper.getMaxOrderGoodsId(type);
    }

    @Override
    public Optional<OrderGoods> getByOrderGoodsNo(String orderGoodsNo) {
        return Optional.of(orderGoodsNo)
                .map(item -> lQrWrapper()
                        .eq(OrderGoods::getOrderGoodsNo, item)
                )
                .map(super::getOne);
    }

    @Override
    public Optional<OrderGoods> getOrderGoodsInfoByOrderGoodsNoForPC(String orderGoodsNo) {
        return Optional.of(orderGoodsNo)
                .map(item -> lQrWrapper()
                        .eq(OrderGoods::getOrderGoodsNo, item.substring(2))
                )
                .map(super::getOne);
    }

    @Override
    public Optional<OrderGoods> getOrderGoodsInfoByOrderGoodsNoForAPP(String orderGoodsNo) {
        return Optional.of(orderGoodsNo)
                .map(item -> lQrWrapper()
                        .eq(OrderGoods::getOrderGoodsNo, item)
                )
                .map(super::getOne);
    }

    @Override
    public IPage<OrderGoodsVO> pageOrderGoodsList(PageOrderGoodsListParam param) {
        Page<OrderGoodsVO> page = Page.of(param.getPage(), param.getPageSize());
        return baseMapper.pageOrderGoodsList(page, param);
    }

}
