package com.clx.performance.dao.impl;

import com.clx.performance.dao.OrderChildImageDao;
import com.clx.performance.mapper.OrderChildImageMapper;
import com.clx.performance.model.OrderChildImage;
import com.msl.common.base.Optional;
import com.msl.common.dao.impl.BaseDaoImpl;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @Author: aiqinguo
 * @Description: 运单表
 * @Date: 2023/09/18 11:34:50
 * @Version: 1.0
 */
@Repository
public class OrderChildImageImpl extends BaseDaoImpl<OrderChildImageMapper, OrderChildImage, Integer> implements OrderChildImageDao {

    @Override
    public boolean deleteLoad(String childNo) {
        return remove(lQrWrapper()
                .eq(OrderChildImage::getChildNo, childNo)
                .eq(OrderChildImage::getType, OrderChildImage.Type.LOAD.getCode())
        );
    }

    @Override
    public boolean deleteUnload(String childNo) {
        return remove(lQrWrapper()
                .eq(OrderChildImage::getChildNo, childNo)
                .eq(OrderChildImage::getType, OrderChildImage.Type.UNLOAD.getCode())
        );
    }

    @Override
    public boolean deleteLoadAndUnload(String childNo) {

        return remove(lQrWrapper()
                .eq(OrderChildImage::getChildNo, childNo)
                .in(OrderChildImage::getType, OrderChildImage.Type.LOAD.getCode(), OrderChildImage.Type.UNLOAD.getCode())
        );

    }

    @Override
    public Optional<List<OrderChildImage>> listLoadAndUnload(String childNo) {
        return Optional.of(childNo)
                .map(item -> lQrWrapper()
                        .eq(OrderChildImage::getChildNo, childNo)
                )
                .map(super::list);
    }

    @Override
    public Optional<List<OrderChildImage>> getImages(String childNo, Integer type) {
        return Optional.ofEmpty(list(lQrWrapper()
                .eq(OrderChildImage::getChildNo, childNo)
                .eq(OrderChildImage::getType, type)));
    }
}
