package com.clx.performance.dao.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.clx.performance.dao.OrderChildDao;
import com.clx.performance.enums.OrderChildEnum;
import com.clx.performance.mapper.OrderChildMapper;
import com.clx.performance.model.OrderChild;
import com.clx.performance.param.app.PageOrderChildOfDriverParam;
import com.clx.performance.param.pc.PagePoundAuditParam;
import com.clx.performance.vo.app.OrderChildVO;
import com.clx.performance.vo.pc.PageOrderChildPoundAuditVO;
import com.msl.common.base.Optional;
import com.msl.common.dao.impl.BaseDaoImpl;
import org.springframework.stereotype.Repository;

import java.time.LocalDateTime;

/**
 * @Author: aiqinguo
 * @Description: 运单表
 * @Date: 2023/09/18 11:34:50
 * @Version: 1.0
 */
@Repository
public class OrderChildDaoImpl extends BaseDaoImpl<OrderChildMapper, OrderChild, Integer> implements OrderChildDao {

    @Override
    public boolean updateStatus(OrderChild item) {
        return update(lUdWrapper()
                .eq(OrderChild::getChildNo, item.getChildNo())
                .set(OrderChild::getStatus, item.getStatus())
        );
    }

    @Override
    public boolean updateCancel(OrderChild item) {
        return update(lUdWrapper()
                .eq(OrderChild::getChildNo, item.getChildNo())
                .set(OrderChild::getStatus, item.getStatus())
        );
    }

    @Override
    public boolean updateLoad(OrderChild item) {
        return update(lUdWrapper()
                .eq(OrderChild::getChildNo, item.getChildNo())
                .set(OrderChild::getLoadRough, item.getLoadRough())
                .set(OrderChild::getLoadTare, item.getLoadTare())
                .set(OrderChild::getLoadNet, item.getLoadNet())

                .set(OrderChild::getLoadTime, item.getLoadTime())
                .set(OrderChild::getWeight, item.getWeight())
                .set(OrderChild::getStatus, item.getStatus())
        );
    }

    @Override
    public boolean updateUnload(OrderChild item) {
        return update(lUdWrapper()
                .eq(OrderChild::getChildNo, item.getChildNo())
                .set(OrderChild::getUnloadRough, item.getUnloadRough())
                .set(OrderChild::getUnloadTare, item.getUnloadTare())
                .set(OrderChild::getUnloadNet, item.getUnloadNet())

                .set(OrderChild::getUnloadTime, item.getUnloadTime())
                .set(OrderChild::getWeight, item.getWeight())
                .set(OrderChild::getPoundStatus, item.getPoundStatus())
                .set(OrderChild::getStatus, item.getStatus())
        );
    }

    @Override
    public boolean updateLoadAndUnload(OrderChild item) {
        return update(lUdWrapper()
                .eq(OrderChild::getChildNo, item.getChildNo())

                .set(OrderChild::getLoadRough, item.getLoadRough())
                .set(OrderChild::getLoadTare, item.getLoadTare())
                .set(OrderChild::getLoadNet, item.getLoadNet())

                .set(OrderChild::getUnloadRough, item.getUnloadRough())
                .set(OrderChild::getUnloadTare, item.getUnloadTare())
                .set(OrderChild::getUnloadNet, item.getUnloadNet())

                .set(OrderChild::getWeight, item.getWeight())
                .set(OrderChild::getPoundStatus, item.getPoundStatus())
        );
    }


    @Override
    public Optional<OrderChild> getByChildNo(String childNo) {
        return Optional.of(childNo)
                .map(item -> lQrWrapper()
                        .eq(OrderChild::getChildNo, item)
                )
                .map(super::getOne);
    }

    @Override
    public long countOfCancel(Long userNo, LocalDateTime startTime, LocalDateTime endTime) {

        return count(lQrWrapper()
                .eq(OrderChild::getChildNo, userNo)
                .eq(OrderChild::getStatus, OrderChildEnum.Status.DRIVER_CANCEL.getCode())
                .ge(OrderChild::getCreateTime, startTime)
                .le(OrderChild::getCreateTime, endTime)
        );
    }

    @Override
    public IPage<OrderChildVO> pageOrderChildOfDriver(PageOrderChildOfDriverParam param) {
        Page<OrderChildVO> page = Page.of(param.getPage(), param.getPageSize());
        return baseMapper.pageOrderChildOfDriver(page,param);
    }

    @Override
    public IPage<PageOrderChildPoundAuditVO> pagePoundAuditList(PagePoundAuditParam param) {
        Page<PageOrderChildPoundAuditVO> page = Page.of(param.getPage(), param.getPageSize());
        return baseMapper.pagePoundAuditList(page,param);
    }

    @Override
    public boolean updatePoundAuditStatus(OrderChild item) {
        return update(lUdWrapper()
                .eq(OrderChild::getChildNo, item.getChildNo())
                .set(OrderChild::getPoundStatus, item.getPoundStatus())
                .set(OrderChild::getLoadNet, item.getLoadNet())
                .set(OrderChild::getUnloadNet, item.getUnloadNet())
        );
    }
}
